/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.AbstractTimelineDatatype;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDataRange;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;

public class XSDDateTimeStamp
extends AbstractTimelineDatatype {
    private static final XSDDateTimeStamp instance = new XSDDateTimeStamp();
    private final RestrictedTimelineDataRange dataRange = new RestrictedTimelineDataRange(this, DatatypeConstants.DATETIME, false);

    public static XSDDateTimeStamp getInstance() {
        return instance;
    }

    private XSDDateTimeStamp() {
        super(Datatypes.DATE_TIME_STAMP, DatatypeConstants.DATETIME);
    }

    @Override
    public RestrictedDataRange<XMLGregorianCalendar> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        return XSDDateTime.getInstance().getLiteral(this.getValue(input));
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDateTime.getInstance();
    }

    @Override
    public XMLGregorianCalendar getValue(Literal literal) throws InvalidLiteralException {
        XMLGregorianCalendar c = super.getValue(literal);
        if (c.getTimezone() == Integer.MIN_VALUE) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
        return c;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

