/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDataRange;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public abstract class AbstractTimelineDatatype
extends AbstractBaseDatatype<XMLGregorianCalendar> {
    private final QName schemaType;

    public AbstractTimelineDatatype(NamedDatatype name, QName schemaType) {
        super(name);
        this.schemaType = schemaType;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        XMLGregorianCalendar c = this.getValue(input);
        String canonicalForm = c.toXMLFormat();
        if (canonicalForm.equals(input.getLexicalValue())) {
            return input;
        }
        return TermFactory.literal(canonicalForm, this.getName());
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)value;
            if (!this.schemaType.equals(c.getXMLSchemaType())) {
                throw new IllegalArgumentException();
            }
            return TermFactory.literal(c.toXMLFormat(), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public XMLGregorianCalendar getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            XMLGregorianCalendar c = RestrictedTimelineDataRange.getDatatypeFactory().newXMLGregorianCalendar(lexicalForm);
            if (!this.schemaType.equals(c.getXMLSchemaType())) {
                throw new InvalidLiteralException(this.getName(), literal);
            }
            return c;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
        catch (IllegalStateException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

