/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.bool.RestrictedBooleanDataRange;

public class XSDBoolean
extends AbstractBaseDatatype<Boolean> {
    private static final XSDBoolean instance = new XSDBoolean();
    private final RestrictedBooleanDataRange dataRange = new RestrictedBooleanDataRange(this);

    public static XSDBoolean getInstance() {
        return instance;
    }

    private XSDBoolean() {
        super(Datatypes.BOOLEAN);
    }

    @Override
    public RestrictedDataRange<Boolean> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        if (input == Literals.FALSE || input == Literals.TRUE) {
            return input;
        }
        return this.getLiteral(this.getValue(input));
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Literals.TRUE : Literals.FALSE;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Boolean getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue().trim();
        if (lexicalForm.equals("true") || lexicalForm.equals("1")) {
            return Boolean.TRUE;
        }
        if (lexicalForm.equals("false") || lexicalForm.equals("0")) {
            return Boolean.FALSE;
        }
        throw new InvalidLiteralException(this.getName(), literal);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

