/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.types.real.Rational;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLRealUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLRealUtils.class);

    public static boolean acceptable(Class<? extends Number> c) {
        return Type.get(c) != null;
    }

    public static BigDecimal bigDecimal(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to bigDecimal method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        BigDecimal d = (BigDecimal)OWLRealUtils.convertFromTo(n, t, Type.BIG_DECIMAL);
        return d;
    }

    public static BigInteger bigInteger(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to bigInteger method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (Type.BIG_INTEGER.equals((Object)t)) {
            return (BigInteger)n;
        }
        BigInteger i = (BigInteger)OWLRealUtils.convertFromTo(n, t, Type.BIG_INTEGER);
        return i;
    }

    public static int compare(Number a, Number b) {
        int sb;
        Type ta = Type.get(a.getClass());
        if (ta == null) {
            throw new IllegalArgumentException();
        }
        Type tb = Type.get(b.getClass());
        if (tb == null) {
            throw new IllegalArgumentException();
        }
        if (ta == tb) {
            return ((Comparable)((Object)a)).compareTo(b);
        }
        int sa = OWLRealUtils.signum(a);
        if (sa == (sb = OWLRealUtils.signum(b))) {
            Type target = Type.compareType(ta, tb);
            Comparable compA = ta == target ? (Comparable)((Object)a) : (Comparable)((Object)OWLRealUtils.convertFromTo(a, ta, target));
            Number compB = tb == target ? (Number)b : (Number)OWLRealUtils.convertFromTo(b, tb, target);
            return compA.compareTo(compB);
        }
        return sa > sb ? 1 : -1;
    }

    private static Number convertFromTo(Number n, Type in, Type out) {
        if (Type.BIG_DECIMAL.equals((Object)in) && out.isIntegerOnly()) {
            in = Type.BIG_INTEGER;
            n = ((BigDecimal)n).toBigIntegerExact();
        }
        switch (out.ordinal()) {
            case 2: {
                if (!in.equals((Object)Type.BYTE)) {
                    throw new IllegalArgumentException();
                }
                return n;
            }
            case 6: {
                switch (in.ordinal()) {
                    case 2: {
                        return n.shortValue();
                    }
                    case 6: {
                        return n;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                switch (in.ordinal()) {
                    case 2: 
                    case 6: {
                        return n.intValue();
                    }
                    case 3: {
                        return n;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                switch (in.ordinal()) {
                    case 2: 
                    case 3: 
                    case 6: {
                        return n.longValue();
                    }
                    case 4: {
                        return n;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                switch (in.ordinal()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        return BigInteger.valueOf(n.longValue());
                    }
                    case 1: {
                        return n;
                    }
                    case 0: {
                        try {
                            return ((BigDecimal)n).toBigIntegerExact();
                        }
                        catch (ArithmeticException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    case 5: {
                        Rational r = (Rational)n;
                        if (OWLRealUtils.compare(1, r.getDenominator()) != 0) {
                            r = Rational.simplify(r);
                            if (OWLRealUtils.compare(1, r.getDenominator()) != 0) {
                                throw new IllegalArgumentException();
                            }
                        }
                        return OWLRealUtils.bigInteger(r.getNumerator());
                    }
                }
                throw new IllegalArgumentException();
            }
            case 0: {
                switch (in.ordinal()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        return BigDecimal.valueOf(n.longValue());
                    }
                    case 1: {
                        return new BigDecimal((BigInteger)n);
                    }
                    case 0: {
                        return n;
                    }
                }
            }
            case 5: {
                switch (in.ordinal()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        return new Rational(n, 1);
                    }
                    case 0: {
                        BigDecimal d = (BigDecimal)n;
                        BigInteger num = d.unscaledValue();
                        int scale = d.scale();
                        BigInteger denom = BigInteger.TEN.pow(scale);
                        return new Rational(num, denom);
                    }
                    case 5: {
                        return n;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number getCanonicalObject(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to integerIncrement method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (OWLRealUtils.isInteger(n)) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(n));
        }
        if (Type.RATIONAL.equals((Object)t)) {
            Rational r = (Rational)n;
            if (r.isQuotientExact()) {
                return OWLRealUtils.getCanonicalObject(r.getQuotient());
            }
            return Rational.simplify(r);
        }
        if (Type.BIG_DECIMAL.equals((Object)t)) {
            BigDecimal d = (BigDecimal)n;
            int shift = 0;
            BigInteger unscaled = d.unscaledValue();
            BigInteger[] dandr = unscaled.divideAndRemainder(BigInteger.TEN);
            while (BigInteger.ZERO.equals(dandr[1])) {
                unscaled = dandr[0];
                --shift;
                dandr = unscaled.divideAndRemainder(BigInteger.TEN);
            }
            return shift == 0 ? d : d.setScale(d.scale() + shift);
        }
        throw new IllegalStateException();
    }

    public static Number integerDecrement(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to integerIncrement method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!t.isIntegerOnly()) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(n).subtract(BigInteger.ONE));
        }
        switch (t.ordinal()) {
            case 2: {
                byte b = n.byteValue();
                if (b > -128) {
                    return (byte)(b - 1);
                }
                return (short)(b - 1);
            }
            case 6: {
                short s = n.shortValue();
                if (s > Short.MIN_VALUE) {
                    return (short)(s - 1);
                }
                return s - 1;
            }
            case 3: {
                int i = n.intValue();
                if (i > Integer.MIN_VALUE) {
                    return i - 1;
                }
                return (long)i - 1L;
            }
            case 4: {
                long l = n.longValue();
                return l > Long.MIN_VALUE ? Long.valueOf(l - 1L) : BigInteger.valueOf(l).subtract(BigInteger.ONE);
            }
            case 1: {
                BigInteger bi = (BigInteger)n;
                return bi.subtract(BigInteger.ONE);
            }
        }
        throw new IllegalStateException();
    }

    public static Number integerDifference(Number a, Number b) {
        Type ta = Type.get(a.getClass());
        Type tb = Type.get(b.getClass());
        if (ta == null || tb == null) {
            String msg = String.format("Unexpected number type %s,%s passed to integerDifference method.", a.getClass().getCanonicalName(), b.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        BigInteger ia = OWLRealUtils.bigInteger(a);
        BigInteger ib = OWLRealUtils.bigInteger(b);
        return OWLRealUtils.shrinkBigInteger(ia.subtract(ib));
    }

    public static Number integerIncrement(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to integerIncrement method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!t.isIntegerOnly()) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(n).add(BigInteger.ONE));
        }
        switch (t.ordinal()) {
            case 2: {
                byte b = n.byteValue();
                if (b < 127) {
                    return (byte)(b + 1);
                }
                return (short)(b + 1);
            }
            case 6: {
                short s = n.shortValue();
                if (s < Short.MAX_VALUE) {
                    return (short)(s + 1);
                }
                return s + 1;
            }
            case 3: {
                int i = n.intValue();
                if (i < Integer.MAX_VALUE) {
                    return i + 1;
                }
                return (long)i + 1L;
            }
            case 4: {
                long l = n.longValue();
                return l < Long.MAX_VALUE ? Long.valueOf(l + 1L) : BigInteger.valueOf(l).add(BigInteger.ONE);
            }
            case 1: {
                BigInteger bi = (BigInteger)n;
                return bi.add(BigInteger.ONE);
            }
        }
        throw new IllegalStateException();
    }

    public static Number integerSum(Number a, Number b) {
        Type ta = Type.get(a.getClass());
        Type tb = Type.get(b.getClass());
        if (ta == null || tb == null) {
            String msg = String.format("Unexpected number type %s,%s passed to integerSum method.", a.getClass().getCanonicalName(), b.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        BigInteger ia = OWLRealUtils.bigInteger(a);
        BigInteger ib = OWLRealUtils.bigInteger(b);
        return OWLRealUtils.shrinkBigInteger(ia.add(ib));
    }

    public static boolean isDecimal(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to isInteger method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return true;
        }
        if (t.equals((Object)Type.BIG_DECIMAL)) {
            return true;
        }
        if (t.equals((Object)Type.RATIONAL)) {
            Rational ratVal = (Rational)n;
            return ratVal.isQuotientExact();
        }
        throw new IllegalStateException();
    }

    public static boolean isInteger(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to isInteger method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return true;
        }
        if (t.equals((Object)Type.BIG_DECIMAL)) {
            BigDecimal decVal = (BigDecimal)n;
            return BigInteger.ZERO.equals(decVal.unscaledValue()) || decVal.stripTrailingZeros().scale() <= 0;
        }
        if (t.equals((Object)Type.RATIONAL)) {
            Rational ratVal = (Rational)n;
            if (OWLRealUtils.compare(1, ratVal.getDenominator()) == 0) {
                return true;
            }
            return OWLRealUtils.compare(1, Rational.simplify(ratVal).getDenominator()) == 0;
        }
        return false;
    }

    public static boolean isRational(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to isInteger method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return true;
        }
        if (t.equals((Object)Type.BIG_DECIMAL)) {
            return true;
        }
        if (t.equals((Object)Type.RATIONAL)) {
            return true;
        }
        throw new IllegalStateException();
    }

    public static String print(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to print method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        switch (t.ordinal()) {
            case 2: {
                return DatatypeConverter.printByte((byte)n.byteValue());
            }
            case 6: {
                return DatatypeConverter.printShort((short)n.shortValue());
            }
            case 3: {
                return DatatypeConverter.printInt((int)n.intValue());
            }
            case 4: {
                return DatatypeConverter.printLong((long)n.longValue());
            }
            case 1: {
                return DatatypeConverter.printInteger((BigInteger)((BigInteger)n));
            }
            case 0: {
                return DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)n));
            }
            case 5: {
                return ((Rational)n).toString();
            }
        }
        throw new IllegalStateException();
    }

    public static Number roundCeiling(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to roundDown method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return n;
        }
        if (Type.BIG_DECIMAL.equals((Object)t)) {
            BigDecimal d = (BigDecimal)n;
            BigDecimal[] dandr = d.divideAndRemainder(BigDecimal.ONE);
            if (dandr[1].equals(BigDecimal.ZERO) || d.signum() == -1) {
                return OWLRealUtils.shrinkBigInteger(dandr[0].toBigIntegerExact());
            }
            return OWLRealUtils.shrinkBigInteger(dandr[0].toBigIntegerExact().add(BigInteger.ONE));
        }
        if (Type.RATIONAL.equals((Object)t)) {
            Rational r = (Rational)n;
            return OWLRealUtils.roundCeiling(r.getQuotient());
        }
        throw new IllegalStateException();
    }

    public static Number roundDown(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to roundDown method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return n;
        }
        if (Type.BIG_DECIMAL.equals((Object)t)) {
            BigDecimal d = (BigDecimal)n;
            return OWLRealUtils.shrinkBigInteger(d.divideToIntegralValue(BigDecimal.ONE).toBigIntegerExact());
        }
        if (Type.RATIONAL.equals((Object)t)) {
            Rational r = (Rational)n;
            return OWLRealUtils.roundDown(r.getQuotient());
        }
        throw new IllegalStateException();
    }

    public static Number roundFloor(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to roundDown method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (t.isIntegerOnly()) {
            return n;
        }
        if (Type.BIG_DECIMAL.equals((Object)t)) {
            BigDecimal d = (BigDecimal)n;
            BigDecimal[] dandr = d.divideAndRemainder(BigDecimal.ONE);
            if (dandr[1].equals(BigDecimal.ZERO) || d.signum() == 1) {
                return OWLRealUtils.shrinkBigInteger(dandr[0].toBigIntegerExact());
            }
            return OWLRealUtils.shrinkBigInteger(dandr[0].toBigIntegerExact().subtract(BigInteger.ONE));
        }
        if (Type.RATIONAL.equals((Object)t)) {
            Rational r = (Rational)n;
            return OWLRealUtils.roundFloor(r.getQuotient());
        }
        throw new IllegalStateException();
    }

    private static Number shrinkBigInteger(BigInteger i) {
        int sign = i.signum();
        if (sign == 0) {
            return (byte)0;
        }
        if (sign < 0) {
            if (i.compareTo(BigInteger.valueOf(-128L)) > 0) {
                return i.byteValue();
            }
            if (i.compareTo(BigInteger.valueOf(-32768L)) > 0) {
                return i.shortValue();
            }
            if (i.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) > 0) {
                return i.intValue();
            }
            if (i.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) > 0) {
                return i.longValue();
            }
            return i;
        }
        if (i.compareTo(BigInteger.valueOf(127L)) < 0) {
            return i.byteValue();
        }
        if (i.compareTo(BigInteger.valueOf(32767L)) < 0) {
            return i.shortValue();
        }
        if (i.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0) {
            return i.intValue();
        }
        if (i.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0) {
            return i.longValue();
        }
        return i;
    }

    public static int signum(Number n) {
        Type t = Type.get(n.getClass());
        if (t == null) {
            String msg = String.format("Unexpected number type %s passed to signum method.", n.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        switch (t.ordinal()) {
            case 0: {
                return ((BigDecimal)n).signum();
            }
            case 1: {
                return ((BigInteger)n).signum();
            }
            case 5: {
                return ((Rational)n).signum();
            }
            case 4: {
                return Long.signum(n.longValue());
            }
            case 2: 
            case 3: 
            case 6: {
                return Integer.signum(n.intValue());
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number sum(Number a, Number b) {
        if (OWLRealUtils.isInteger(a) && OWLRealUtils.isInteger(b)) {
            return OWLRealUtils.integerSum(a, b);
        }
        Type ta = Type.get(a.getClass());
        Type tb = Type.get(b.getClass());
        if (ta == null || tb == null) {
            String msg = String.format("Unexpected number type %s,%s passed to integerSum method.", a.getClass().getCanonicalName(), b.getClass().getCanonicalName());
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (EnumSet.of(ta, tb).contains((Object)Type.RATIONAL)) {
            String msg = String.format("Addition for rational numbers is not supported", new Object[0]);
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        BigDecimal da = (BigDecimal)OWLRealUtils.convertFromTo(a, ta, Type.BIG_DECIMAL);
        BigDecimal db = (BigDecimal)OWLRealUtils.convertFromTo(b, tb, Type.BIG_DECIMAL);
        return OWLRealUtils.getCanonicalObject(da.add(db));
    }

    private static enum Type {
        BIG_DECIMAL(5, BigDecimal.class, false),
        BIG_INTEGER(4, BigInteger.class, true),
        BYTE(0, Byte.class, true),
        INTEGER(2, Integer.class, true),
        LONG(3, Long.class, true),
        RATIONAL(6, Rational.class, false),
        SHORT(1, Short.class, true);

        private static Map<Class<?>, Type> map;
        private final Class<? extends Number> cls;
        private final int index;
        private final boolean integerOnly;

        public static Type compareType(Type a, Type b) {
            return a.index > b.index ? a : b;
        }

        public static Type get(Class<? extends Number> cls) {
            return map.get(cls);
        }

        private Type(int index, Class<? extends Number> cls, boolean integerOnly) {
            this.index = index;
            this.cls = cls;
            this.integerOnly = integerOnly;
        }

        public boolean isIntegerOnly() {
            return this.integerOnly;
        }

        static {
            map = new HashMap();
            for (Type t : Type.values()) {
                map.put(t.cls, t);
            }
        }
    }
}

