/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.PelletOptions;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Types;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.FacetRestriction;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.clarkparsia.pellet.datatypes.DataRange;
import com.clarkparsia.pellet.datatypes.DataValueEnumeration;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.EmptyDataRange;
import com.clarkparsia.pellet.datatypes.InfiniteNamedDatatype;
import com.clarkparsia.pellet.datatypes.NamedDataRangeExpander;
import com.clarkparsia.pellet.datatypes.NamedDatatype;
import com.clarkparsia.pellet.datatypes.NegatedDataRange;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.UnionDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidDatatypeRestrictionException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.datatypes.types.bool.XSDBoolean;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTimeStamp;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonthDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYear;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYearMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.datatypes.types.duration.XSDDuration;
import com.clarkparsia.pellet.datatypes.types.floating.XSDDouble;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.XSDByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDShort;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedShort;
import com.clarkparsia.pellet.datatypes.types.text.RDFLangString;
import com.clarkparsia.pellet.datatypes.types.text.XSDLanguage;
import com.clarkparsia.pellet.datatypes.types.text.XSDNCName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNMToken;
import com.clarkparsia.pellet.datatypes.types.text.XSDName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNormalizedString;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import com.clarkparsia.pellet.datatypes.types.text.XSDToken;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeReasonerImpl
implements DatatypeReasoner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatatypeReasonerImpl.class);
    public static final Map<com.clarkparsia.pellet.api.term.entity.NamedDatatype, Datatype<?>> coreDatatypes = Maps.newHashMap();
    private static final DataRange<?> EMPTY_RANGE;
    private static final DataRange<?> TRIVIALLY_SATISFIABLE;
    private final Set<com.clarkparsia.pellet.api.term.entity.NamedDatatype> declaredUndefined = Sets.newHashSet();
    private final NamedDataRangeExpander expander = new NamedDataRangeExpander();
    private final Map<com.clarkparsia.pellet.api.term.entity.NamedDatatype, com.clarkparsia.pellet.api.term.entity.Datatype> namedDataRanges = Maps.newHashMap();

    private static <T> DataValueEnumeration<? extends T> findSmallestEnumeration(Collection<DataValueEnumeration<? extends T>> ranges) {
        DataValueEnumeration<T> ret = null;
        int best = Integer.MAX_VALUE;
        for (DataValueEnumeration<T> r : ranges) {
            DataValueEnumeration<T> e = r;
            int s = e.size();
            if (s >= best) continue;
            ret = e;
            best = s;
        }
        return ret;
    }

    private static int inequalityCount(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        return others == null ? 0 : others.size();
    }

    private static <T> void partitionDConjunction(Collection<DataRange<? extends T>> dconjunction, Set<DataValueEnumeration<? extends T>> positiveEnumerations, Set<DataValueEnumeration<? extends T>> negativeEnumerations, Set<RestrictedDataRange<? extends T>> positiveRestrictions, Set<RestrictedDataRange<? extends T>> negativeRestrictions) {
        for (DataRange<T> dataRange : dconjunction) {
            if (dataRange instanceof DataValueEnumeration) {
                positiveEnumerations.add((DataValueEnumeration)dataRange);
                continue;
            }
            if (dataRange instanceof RestrictedDataRange) {
                positiveRestrictions.add((RestrictedDataRange)dataRange);
                continue;
            }
            if (dataRange instanceof NegatedDataRange) {
                DataRange ndr = ((NegatedDataRange)dataRange).getDataRange();
                if (ndr instanceof DataValueEnumeration) {
                    negativeEnumerations.add((DataValueEnumeration)ndr);
                    continue;
                }
                if (ndr instanceof RestrictedDataRange) {
                    negativeRestrictions.add((RestrictedDataRange)ndr);
                    continue;
                }
                if (dataRange == TRIVIALLY_SATISFIABLE) continue;
                LOGGER.warn("Unknown datatype: {}", dataRange);
                continue;
            }
            if (dataRange == TRIVIALLY_SATISFIABLE) continue;
            LOGGER.warn("Unknown datatype: {}", dataRange);
        }
    }

    private static boolean removeInequalities(Set<Integer>[] nes, int xIndex) {
        Set<Integer> others = nes[xIndex];
        if (others == null) {
            return false;
        }
        for (Integer yIndex : others) {
            Set<Integer> s = nes[yIndex];
            if (s == null) {
                throw new IllegalStateException();
            }
            if (s.remove(xIndex)) continue;
            throw new IllegalStateException();
        }
        return true;
    }

    public DatatypeReasonerImpl() {
        this.declaredUndefined.add(Datatypes.LITERAL);
        this.declaredUndefined.add(Datatypes.BASE_64_BINARY);
        this.declaredUndefined.add(Datatypes.HEX_BINARY);
        this.declaredUndefined.add(Datatypes.XML_LITERAL);
    }

    private boolean containedIn(Object value, com.clarkparsia.pellet.api.term.entity.Datatype dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (dconjunction instanceof DataAnd) {
            for (com.clarkparsia.pellet.api.term.entity.Datatype d : (DataAnd)dconjunction) {
                if (this.getDataRange(d).contains(value)) continue;
                return false;
            }
            return true;
        }
        return this.getDataRange(dconjunction).contains(value);
    }

    @Override
    public boolean containsAtLeast(int n, Collection<com.clarkparsia.pellet.api.term.entity.Datatype> ranges) throws UnrecognizedDatatypeException, InvalidConstrainingFacetException, InvalidLiteralException {
        com.clarkparsia.pellet.api.term.entity.Datatype and = TermFactory.dataAnd(ranges);
        com.clarkparsia.pellet.api.term.entity.Datatype dnf = Types.dnf(this.expander.expand(and, this.namedDataRanges));
        if (dnf instanceof DataOr) {
            ArrayList disjuncts = new ArrayList();
            for (com.clarkparsia.pellet.api.term.entity.Datatype disj : (DataOr)dnf) {
                DataRange<?> dr = this.normalizeVarRanges(disj);
                if (dr.isEmpty()) continue;
                disjuncts.add(dr);
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            return disjunction.containsAtLeast(n);
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        return dr.containsAtLeast(n);
    }

    @Override
    public boolean declare(com.clarkparsia.pellet.api.term.entity.NamedDatatype name) {
        if (this.isDeclared(name)) {
            return false;
        }
        this.declaredUndefined.add(name);
        return true;
    }

    @Override
    public Literal getCanonicalRepresentation(LiteralValue value) throws InvalidLiteralException, UnrecognizedDatatypeException {
        Literal literal = (Literal)value;
        com.clarkparsia.pellet.api.term.entity.NamedDatatype dtName = literal.getDatatype();
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, literal);
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getCanonicalRepresentation(literal);
    }

    private DataRange<?> getDataRange(com.clarkparsia.pellet.api.term.entity.Datatype datatype) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return (DataRange)datatype.accept(new BaseTermVisitor<DataRange<?>>(){

            @Override
            public DataRange<?> visit(com.clarkparsia.pellet.api.term.entity.NamedDatatype a) {
                if (a.equals(Datatypes.TOP)) {
                    return TRIVIALLY_SATISFIABLE;
                }
                InfiniteNamedDatatype dt = DatatypeReasonerImpl.this.getDatatype(a);
                if (dt == null) {
                    switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                        case INFINITE_STRING: {
                            dt = InfiniteNamedDatatype.get(a);
                            break;
                        }
                        case EMPTY: {
                            return EMPTY_RANGE;
                        }
                        case EXCEPTION: {
                            throw new UnrecognizedDatatypeException(a);
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                return dt.asDataRange();
            }

            @Override
            public DataRange<?> visit(DataNot a) {
                if (a.equals(Datatypes.BOTTOM)) {
                    return EMPTY_RANGE;
                }
                DataRange<?> ndr = DatatypeReasonerImpl.this.getDataRange(a.getArg());
                NegatedDataRange dr = new NegatedDataRange(ndr);
                return dr;
            }

            @Override
            public DataRange<?> visit(RestrictedDatatype a) {
                DataRange<?> dt = DatatypeReasonerImpl.this.getDataRange(a.getDatatype());
                if (!(dt instanceof RestrictedDataRange)) {
                    throw new InvalidDatatypeRestrictionException(a);
                }
                RestrictedDataRange dr = (RestrictedDataRange)dt;
                for (FacetRestriction facetRestriction : a.getRestrictions()) {
                    Object value;
                    Facet facet = facetRestriction.getFacet();
                    LiteralValue valueTerm = facetRestriction.getValue();
                    try {
                        value = DatatypeReasonerImpl.this.getValue(valueTerm);
                    }
                    catch (InvalidLiteralException e) {
                        throw new InvalidConstrainingFacetException(facet, valueTerm, e);
                    }
                    dr = dr.applyConstrainingFacet(facet, value);
                }
                return dr;
            }

            @Override
            public DataRange<?> visit(DataOneOf a) {
                LiteralValue literal = (LiteralValue)a.getArgs().iterator().next();
                DataValueEnumeration<Object> dr = new DataValueEnumeration<Object>(Collections.singleton(DatatypeReasonerImpl.this.getValue(literal)));
                return dr;
            }

            @Override
            public DataRange<?> defaultVisit(Term a) {
                String msg = String.format("Unrecognized input term (%s) for datarange conversion", a);
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
        });
    }

    @Override
    public Datatype<?> getDatatype(com.clarkparsia.pellet.api.term.entity.NamedDatatype uri) {
        try {
            com.clarkparsia.pellet.api.term.entity.Datatype definition;
            Datatype<?> dt = coreDatatypes.get(uri);
            if (dt == null && (definition = this.namedDataRanges.get(uri)) != null && definition instanceof RestrictedDatatype) {
                RestrictedDataRange dataRange = (RestrictedDataRange)this.getDataRange(definition);
                NamedDatatype namedDatatype = new NamedDatatype(uri, dataRange);
                dt = namedDatatype;
            }
            return dt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<com.clarkparsia.pellet.api.term.entity.NamedDatatype> getDatatypes() {
        return Sets.union(coreDatatypes.keySet(), (Set)Sets.union(this.namedDataRanges.keySet(), this.declaredUndefined));
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> getDisjunction(Collection<DataRange<?>> ranges) {
        Iterator<Object> it;
        if (ranges.size() == 1) {
            return ranges.iterator().next();
        }
        for (DataRange<?> r : ranges) {
            if (r != TRIVIALLY_SATISFIABLE) continue;
            return r;
        }
        Set oneOf = Collections.emptySet();
        HashMap byPrimitive = new HashMap();
        for (DataRange<?> dr : ranges) {
            if (dr instanceof RestrictedDataRange) {
                void var8_8;
                RestrictedDataRange rd = (RestrictedDataRange)dr;
                Datatype<?> pd = rd.getDatatype().getPrimitiveDatatype();
                Set set = (Set)byPrimitive.get(pd);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    byPrimitive.put(pd, hashSet);
                }
                var8_8.add(rd);
                continue;
            }
            if (!(dr instanceof DataValueEnumeration)) continue;
            DataValueEnumeration enm = (DataValueEnumeration)dr;
            if (oneOf.isEmpty()) {
                oneOf = new HashSet();
            }
            it = enm.valueIterator();
            while (it.hasNext()) {
                oneOf.add(it.next());
            }
        }
        HashSet disjointRanges = new HashSet();
        for (Set s : byPrimitive.values()) {
            void var8_13;
            it = s.iterator();
            RestrictedDataRange restrictedDataRange = (RestrictedDataRange)it.next();
            while (it.hasNext()) {
                RestrictedDataRange restrictedDataRange2 = var8_13.union((RestrictedDataRange)it.next());
            }
            disjointRanges.add(var8_13);
        }
        Iterator it2 = oneOf.iterator();
        while (it2.hasNext()) {
            Object o = it2.next();
            for (RestrictedDataRange restrictedDataRange : disjointRanges) {
                if (!restrictedDataRange.contains(o)) continue;
                it2.remove();
            }
        }
        return new UnionDataRange(disjointRanges, oneOf);
    }

    @Override
    public Literal getLiteral(Object value) {
        for (Datatype<?> dt : coreDatatypes.values()) {
            if (!dt.isPrimitive() || !dt.asDataRange().contains(value)) continue;
            return dt.getLiteral(value);
        }
        String msg = "Value is not in the value space of any recognized datatypes: " + value.toString();
        LOGGER.error(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public Object getValue(LiteralValue value) throws InvalidLiteralException, UnrecognizedDatatypeException {
        if (value.isVariable()) {
            throw new IllegalArgumentException();
        }
        Literal literal = (Literal)value;
        com.clarkparsia.pellet.api.term.entity.NamedDatatype dtName = literal.getDatatype();
        Datatype<?> dt = this.getDatatype(dtName);
        if (dt == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return literal;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(dtName, literal);
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(dtName);
                }
            }
            throw new IllegalStateException();
        }
        return dt.getValue(literal);
    }

    @Override
    public boolean isDeclared(com.clarkparsia.pellet.api.term.entity.NamedDatatype name) {
        return Datatypes.TOP.equals(name) || coreDatatypes.containsKey(name) || this.namedDataRanges.containsKey(name) || this.declaredUndefined.contains(name);
    }

    @Override
    public boolean isDefined(com.clarkparsia.pellet.api.term.entity.NamedDatatype name) {
        if (Datatypes.TOP.equals(name)) {
            return true;
        }
        if (coreDatatypes.containsKey(name)) {
            return true;
        }
        return this.namedDataRanges.containsKey(name);
    }

    @Override
    public com.clarkparsia.pellet.api.term.entity.Datatype getDefinition(com.clarkparsia.pellet.api.term.entity.NamedDatatype name) {
        return this.namedDataRanges.get(name);
    }

    @Override
    public boolean isSatisfiable(Collection<com.clarkparsia.pellet.api.term.entity.Datatype> datatypes) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return this.isSatisfiable(datatypes, null);
    }

    @Override
    public boolean isSatisfiable(Collection<com.clarkparsia.pellet.api.term.entity.Datatype> datatypes, Object value) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Set<Integer> vars;
        HashSet<Integer> consts;
        if (value == null) {
            consts = new HashSet();
            vars = new HashSet<Integer>(Collections.singleton(0));
        } else {
            consts = Collections.singleton(0);
            vars = Collections.emptySet();
        }
        com.clarkparsia.pellet.api.term.entity.Datatype and = TermFactory.dataAnd(datatypes);
        com.clarkparsia.pellet.api.term.entity.Datatype dnf = Types.dnf(this.expander.expand(and, this.namedDataRanges));
        Collection<com.clarkparsia.pellet.api.term.entity.Datatype> dnfDisjuncts = dnf instanceof DataOr ? ((DataOr)dnf).getArgs() : Collections.singleton(dnf);
        Collection[] dnfTypes = new Collection[]{dnfDisjuncts};
        Set[] ne = new Set[]{Collections.emptySet()};
        return this.isSatisfiable(consts, vars, dnfTypes, new Object[]{value}, ne);
    }

    private boolean isSatisfiable(Set<Integer> consts, Set<Integer> vars, Collection<com.clarkparsia.pellet.api.term.entity.Datatype>[] dnfTypes, Object[] constValues, Set<Integer>[] ne) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Object dr;
        int n = dnfTypes.length;
        for (int i = 0; i < n; ++i) {
            Collection<com.clarkparsia.pellet.api.term.entity.Datatype> drs = dnfTypes[i];
            Iterator<com.clarkparsia.pellet.api.term.entity.Datatype> it2 = drs.iterator();
            while (it2.hasNext()) {
                dr = it2.next();
                if (!Datatypes.BOTTOM.equals(dr)) continue;
                it2.remove();
            }
            if (!drs.isEmpty()) continue;
            return false;
        }
        DataRange[] normalized = new DataRange[n];
        for (int i = 0; i < n; ++i) {
            if (consts.contains(i)) {
                boolean satisfied = false;
                for (com.clarkparsia.pellet.api.term.entity.Datatype datatype : dnfTypes[i]) {
                    if (!this.containedIn(constValues[i], datatype)) continue;
                    satisfied = true;
                    break;
                }
                if (satisfied) {
                    normalized[i] = TRIVIALLY_SATISFIABLE;
                    continue;
                }
                return false;
            }
            List<DataRange<?>> drs = new ArrayList();
            for (com.clarkparsia.pellet.api.term.entity.Datatype datatype : dnfTypes[i]) {
                DataRange<?> dr2 = this.normalizeVarRanges(datatype);
                if (dr2 == TRIVIALLY_SATISFIABLE) {
                    drs = Collections.singletonList(TRIVIALLY_SATISFIABLE);
                    break;
                }
                if (dr2.isEmpty()) continue;
                drs.add(dr2);
            }
            if (drs.isEmpty()) {
                return false;
            }
            normalized[i] = this.getDisjunction(drs);
        }
        Iterator<Integer> it3 = vars.iterator();
        while (it3.hasNext()) {
            Integer i = it3.next();
            dr = normalized[i];
            if (TRIVIALLY_SATISFIABLE == dr) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (dr.isEmpty()) {
                return false;
            }
            if (dr.containsAtLeast(DatatypeReasonerImpl.inequalityCount(ne, i) + 1)) {
                it3.remove();
                DatatypeReasonerImpl.removeInequalities(ne, i);
                continue;
            }
            if (!dr.isFinite() || !dr.isEnumerable() || dr.containsAtLeast(2)) continue;
            Object t = dr.valueIterator().next();
            it3.remove();
            consts.add(i);
            constValues[i.intValue()] = t;
            normalized[i.intValue()] = TRIVIALLY_SATISFIABLE;
        }
        LOGGER.trace("After variable data range normalization {} variables and {} constants", (Object)vars.size(), (Object)consts.size());
        for (Integer i : consts) {
            Set<Integer> diffs = ne[i];
            if (diffs == null) continue;
            Iterator<Integer> iterator = diffs.iterator();
            while (iterator.hasNext()) {
                int j = iterator.next();
                if (!consts.contains(j)) continue;
                if (constValues[i].equals(constValues[j])) {
                    return false;
                }
                iterator.remove();
                ne[j].remove(i);
            }
        }
        Iterator<Integer> it = vars.iterator();
        while (it.hasNext()) {
            Set<Integer> set;
            int min;
            int i = it.next();
            dr = normalized[i];
            if (!dr.containsAtLeast(min = (set = ne[i]) == null ? 1 : set.size() + 1)) continue;
            it.remove();
            for (int j : set) {
                if (ne[j] == null) continue;
                ne[j].remove(i);
            }
            ne[i] = null;
            vars.remove(i);
        }
        LOGGER.trace("After size check on variable data ranges {} variables", (Object)vars.size());
        if (vars.isEmpty()) {
            return true;
        }
        HashSet<Integer> remaining = new HashSet<Integer>(vars);
        ArrayList partitions = new ArrayList();
        while (!remaining.isEmpty()) {
            HashSet<Integer> p = new HashSet<Integer>();
            Iterator iterator = remaining.iterator();
            int i = (Integer)iterator.next();
            iterator.remove();
            p.add(i);
            if (ne[i] != null) {
                HashSet<Integer> others = new HashSet<Integer>();
                others.addAll(ne[i]);
                while (!others.isEmpty()) {
                    Iterator jt = others.iterator();
                    int j = (Integer)jt.next();
                    jt.remove();
                    if (!remaining.contains(j)) continue;
                    p.add(j);
                    remaining.remove(j);
                    if (ne[j] == null) continue;
                    others.addAll(ne[j]);
                }
            }
            partitions.add(p);
        }
        LOGGER.trace("Enumerating to find solutions for {} partitions", (Object)partitions.size());
        for (Set set : partitions) {
            int nPart = set.size();
            int[] indices = new int[nPart];
            HashMap<Integer, Integer> revInd = new HashMap<Integer, Integer>();
            DataRange[] drs = new DataRange[nPart];
            int i = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                drs[i] = normalized[j];
                indices[i] = j;
                revInd.put(j, i);
                ++i;
            }
            Iterator[] its = new Iterator[nPart];
            for (i = 0; i < nPart; ++i) {
                its[i] = drs[i].valueIterator();
            }
            Object[] values = new Object[nPart];
            for (i = 0; i < nPart; ++i) {
                values[i] = its[i].next();
            }
            boolean solutionFound = false;
            while (!solutionFound) {
                solutionFound = true;
                block17: for (i = 0; i < nPart && solutionFound; ++i) {
                    Set<Integer> diffs = ne[indices[i]];
                    if (diffs == null) continue;
                    Object a = values[i];
                    for (int j : diffs) {
                        Object b = set.contains(j) ? values[(Integer)revInd.get(j)] : constValues[j];
                        if (!a.equals(b)) continue;
                        solutionFound = false;
                        continue block17;
                    }
                }
                if (solutionFound) continue;
                i = nPart - 1;
                while (!its[i].hasNext()) {
                    if (i == 0) {
                        return false;
                    }
                    its[i] = drs[i].valueIterator();
                    values[i] = its[i].next();
                    --i;
                }
                values[i] = its[i].next();
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable(Map<LiteralValue, Set<com.clarkparsia.pellet.api.term.entity.Datatype>> lits, Map<LiteralValue, Set<LiteralValue>> neqs) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        LiteralValue[] literals = lits.keySet().toArray(new LiteralValue[0]);
        HashSet<Integer> vars = new HashSet<Integer>();
        HashSet<Integer> consts = new HashSet<Integer>();
        Object[] constValues = new Object[literals.length];
        HashMap<LiteralValue, Integer> rev = new HashMap<LiteralValue, Integer>();
        for (int i = 0; i < literals.length; ++i) {
            rev.put(literals[i], i);
            if (!literals[i].isVariable()) {
                consts.add(i);
                constValues[i] = this.getValue(literals[i]);
                continue;
            }
            vars.add(i);
        }
        Set[] ne = new Set[literals.length];
        for (Map.Entry<LiteralValue, Set<LiteralValue>> e : neqs.entrySet()) {
            int index = (Integer)rev.get(e.getKey());
            ne[index] = new HashSet();
            for (LiteralValue l : e.getValue()) {
                ne[index].add((Integer)rev.get(l));
            }
        }
        LOGGER.trace("Checking satisfiability for {} variables and {} constants", (Object)vars.size(), (Object)consts.size());
        Collection[] dnfs = new Collection[literals.length];
        for (int i = 0; i < literals.length; ++i) {
            Collection datatypes = lits.get(literals[i]);
            com.clarkparsia.pellet.api.term.entity.Datatype and = TermFactory.dataAnd(datatypes);
            com.clarkparsia.pellet.api.term.entity.Datatype dnf = Types.dnf(this.expander.expand(and, this.namedDataRanges));
            dnfs[i] = dnf instanceof DataOr ? ((DataOr)dnf).getArgs() : ImmutableSet.of((Object)dnf);
        }
        return this.isSatisfiable(consts, vars, dnfs, constValues, ne);
    }

    @Override
    public boolean define(com.clarkparsia.pellet.api.term.entity.NamedDatatype name, com.clarkparsia.pellet.api.term.entity.Datatype datarange) {
        if (name.equals(datarange)) {
            throw new IllegalArgumentException();
        }
        if (this.namedDataRanges.containsKey(name)) {
            return false;
        }
        this.namedDataRanges.put(name, datarange);
        this.declaredUndefined.remove(name);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> normalizeVarRanges(com.clarkparsia.pellet.api.term.entity.Datatype dconjunction) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        DataRange<?> ret;
        if (dconjunction instanceof DataAnd) {
            void var10_19;
            void var10_16;
            LinkedHashSet ranges = new LinkedHashSet();
            for (com.clarkparsia.pellet.api.term.entity.Datatype conj : (DataAnd)dconjunction) {
                DataRange<?> dr = this.getDataRange(conj);
                if (dr.isEmpty()) {
                    return EMPTY_RANGE;
                }
                ranges.add(dr);
            }
            HashSet positiveEnumerations = new HashSet();
            HashSet negativeEnumerations = new HashSet();
            HashSet positiveRestrictions = new HashSet();
            HashSet negativeRestrictions = new HashSet();
            DatatypeReasonerImpl.partitionDConjunction(ranges, positiveEnumerations, negativeEnumerations, positiveRestrictions, negativeRestrictions);
            if (!positiveEnumerations.isEmpty()) {
                DataValueEnumeration enumeration = DatatypeReasonerImpl.findSmallestEnumeration(positiveEnumerations);
                HashSet remainingValues = new HashSet();
                Iterator iterator = enumeration.valueIterator();
                boolean same = true;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    boolean bl = true;
                    for (DataRange dataRange : ranges) {
                        if (dataRange == enumeration || dataRange.contains(t)) continue;
                        bl = false;
                        same = false;
                        break;
                    }
                    if (!bl) continue;
                    remainingValues.add(t);
                }
                if (same) {
                    return enumeration;
                }
                if (remainingValues.isEmpty()) {
                    return EMPTY_RANGE;
                }
                return new DataValueEnumeration(remainingValues);
            }
            if (positiveRestrictions.isEmpty()) {
                return TRIVIALLY_SATISFIABLE;
            }
            Datatype<?> rootDt = null;
            for (RestrictedDataRange restrictedDataRange : positiveRestrictions) {
                Datatype<?> dt = restrictedDataRange.getDatatype().getPrimitiveDatatype();
                if (rootDt == null) {
                    rootDt = dt;
                    continue;
                }
                if (rootDt.equals(dt)) continue;
                return EMPTY_RANGE;
            }
            Iterator it = positiveRestrictions.iterator();
            RestrictedDataRange restrictedDataRange = (RestrictedDataRange)it.next();
            while (it.hasNext()) {
                void var10_14;
                RestrictedDataRange other = (RestrictedDataRange)it.next();
                RestrictedDataRange restrictedDataRange2 = var10_14.intersect(other, false);
            }
            for (RestrictedDataRange restrictedDataRange3 : negativeRestrictions) {
                Datatype<?> datatype;
                if (restrictedDataRange3.isEmpty() || !rootDt.equals(datatype = restrictedDataRange3.getDatatype().getPrimitiveDatatype())) continue;
                RestrictedDataRange restrictedDataRange4 = var10_16.intersect(restrictedDataRange3, true);
            }
            if (!negativeEnumerations.isEmpty()) {
                HashSet notOneOf = new HashSet();
                for (DataValueEnumeration dataValueEnumeration : negativeEnumerations) {
                    Iterator oi = dataValueEnumeration.valueIterator();
                    while (oi.hasNext()) {
                        notOneOf.add(oi.next());
                    }
                }
                RestrictedDataRange restrictedDataRange5 = var10_16.exclude(notOneOf);
            }
            ret = var10_19;
        } else {
            ret = this.getDataRange(dconjunction);
        }
        if (!ret.isFinite()) {
            return TRIVIALLY_SATISFIABLE;
        }
        return ret;
    }

    @Override
    public Collection<com.clarkparsia.pellet.api.term.entity.Datatype> listDataRanges() {
        return ImmutableList.builder().addAll(coreDatatypes.keySet()).addAll(this.declaredUndefined).addAll(this.namedDataRanges.keySet()).build();
    }

    @Override
    public boolean validLiteral(Literal theLiteral) throws UnrecognizedDatatypeException {
        com.clarkparsia.pellet.api.term.entity.NamedDatatype dtTerm = theLiteral.getDatatype();
        Datatype<?> dt = this.getDatatype(dtTerm);
        if (dt == null) {
            throw new UnrecognizedDatatypeException(dtTerm);
        }
        try {
            dt.getValue(theLiteral);
        }
        catch (InvalidLiteralException e) {
            return false;
        }
        return true;
    }

    @Override
    public Iterator<?> valueIterator(Collection<com.clarkparsia.pellet.api.term.entity.Datatype> datatypes) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        com.clarkparsia.pellet.api.term.entity.Datatype and = TermFactory.dataAnd(datatypes);
        com.clarkparsia.pellet.api.term.entity.Datatype dnf = Types.dnf(this.expander.expand(and, this.namedDataRanges));
        if (dnf instanceof DataOr) {
            ArrayList disjuncts = new ArrayList();
            for (com.clarkparsia.pellet.api.term.entity.Datatype disj : (DataOr)dnf) {
                DataRange<?> dr = this.normalizeVarRanges(disj);
                disjuncts.add(dr);
            }
            DataRange<?> disjunction = this.getDisjunction(disjuncts);
            if (!disjunction.isEnumerable()) {
                throw new IllegalArgumentException();
            }
            return disjunction.valueIterator();
        }
        DataRange<?> dr = this.normalizeVarRanges(dnf);
        if (!dr.isEnumerable()) {
            throw new IllegalArgumentException();
        }
        return dr.valueIterator();
    }

    static {
        coreDatatypes.put(XSDString.getInstance().getName(), XSDString.getInstance());
        coreDatatypes.put(RDFLangString.getInstance().getName(), RDFLangString.getInstance());
        coreDatatypes.put(XSDNormalizedString.getInstance().getName(), XSDNormalizedString.getInstance());
        coreDatatypes.put(XSDToken.getInstance().getName(), XSDToken.getInstance());
        coreDatatypes.put(XSDLanguage.getInstance().getName(), XSDLanguage.getInstance());
        coreDatatypes.put(XSDNMToken.getInstance().getName(), XSDNMToken.getInstance());
        coreDatatypes.put(XSDName.getInstance().getName(), XSDName.getInstance());
        coreDatatypes.put(XSDNCName.getInstance().getName(), XSDNCName.getInstance());
        coreDatatypes.put(XSDBoolean.getInstance().getName(), XSDBoolean.getInstance());
        coreDatatypes.put(OWLReal.getInstance().getName(), OWLReal.getInstance());
        coreDatatypes.put(OWLRational.getInstance().getName(), OWLRational.getInstance());
        coreDatatypes.put(XSDDecimal.getInstance().getName(), XSDDecimal.getInstance());
        coreDatatypes.put(XSDInteger.getInstance().getName(), XSDInteger.getInstance());
        coreDatatypes.put(XSDLong.getInstance().getName(), XSDLong.getInstance());
        coreDatatypes.put(XSDInt.getInstance().getName(), XSDInt.getInstance());
        coreDatatypes.put(XSDShort.getInstance().getName(), XSDShort.getInstance());
        coreDatatypes.put(XSDByte.getInstance().getName(), XSDByte.getInstance());
        coreDatatypes.put(XSDNonNegativeInteger.getInstance().getName(), XSDNonNegativeInteger.getInstance());
        coreDatatypes.put(XSDNonPositiveInteger.getInstance().getName(), XSDNonPositiveInteger.getInstance());
        coreDatatypes.put(XSDNegativeInteger.getInstance().getName(), XSDNegativeInteger.getInstance());
        coreDatatypes.put(XSDPositiveInteger.getInstance().getName(), XSDPositiveInteger.getInstance());
        coreDatatypes.put(XSDUnsignedLong.getInstance().getName(), XSDUnsignedLong.getInstance());
        coreDatatypes.put(XSDUnsignedInt.getInstance().getName(), XSDUnsignedInt.getInstance());
        coreDatatypes.put(XSDUnsignedShort.getInstance().getName(), XSDUnsignedShort.getInstance());
        coreDatatypes.put(XSDUnsignedByte.getInstance().getName(), XSDUnsignedByte.getInstance());
        coreDatatypes.put(XSDDouble.getInstance().getName(), XSDDouble.getInstance());
        coreDatatypes.put(XSDFloat.getInstance().getName(), XSDFloat.getInstance());
        coreDatatypes.put(XSDDateTime.getInstance().getName(), XSDDateTime.getInstance());
        coreDatatypes.put(XSDDateTimeStamp.getInstance().getName(), XSDDateTimeStamp.getInstance());
        coreDatatypes.put(XSDDate.getInstance().getName(), XSDDate.getInstance());
        coreDatatypes.put(XSDGYearMonth.getInstance().getName(), XSDGYearMonth.getInstance());
        coreDatatypes.put(XSDGMonthDay.getInstance().getName(), XSDGMonthDay.getInstance());
        coreDatatypes.put(XSDGYear.getInstance().getName(), XSDGYear.getInstance());
        coreDatatypes.put(XSDGMonth.getInstance().getName(), XSDGMonth.getInstance());
        coreDatatypes.put(XSDGDay.getInstance().getName(), XSDGDay.getInstance());
        coreDatatypes.put(XSDTime.getInstance().getName(), XSDTime.getInstance());
        coreDatatypes.put(XSDDuration.getInstance().getName(), XSDDuration.getInstance());
        coreDatatypes.put(XSDAnyURI.getInstance().getName(), XSDAnyURI.getInstance());
        EMPTY_RANGE = new EmptyDataRange();
        TRIVIALLY_SATISFIABLE = new DataRange<Object>(){

            @Override
            public boolean contains(Object value) {
                return true;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public Object getValue(int i) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Object> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

