/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.rule;

import com.clarkparsia.pellet.api.query.ConstructQuery;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermSet;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.query.QueryAnd;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.clarkparsia.pellet.api.term.query.QueryNamedGraph;
import com.clarkparsia.pellet.api.term.query.QueryNot;
import com.clarkparsia.pellet.api.term.query.QueryOr;
import com.clarkparsia.pellet.api.term.rule.Rule;
import com.clarkparsia.pellet.api.term.rule.RuleAtom;
import com.clarkparsia.pellet.api.term.rule.RuleBuilder;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitorVoid;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RuleFactory {
    private RuleFactory() {
    }

    public static RuleBuilder head() {
        return new RuleBuilder((Collection<? extends RuleAtom>)ImmutableSet.of());
    }

    public static RuleBuilder head(RuleAtom headAtom) {
        return new RuleBuilder((Collection<? extends RuleAtom>)ImmutableSet.of((Object)headAtom));
    }

    public static RuleBuilder head(RuleAtom ... headAtoms) {
        return new RuleBuilder((Collection<? extends RuleAtom>)ImmutableSet.copyOf((Object[])headAtoms));
    }

    public static RuleBuilder head(Collection<? extends RuleAtom> headAtoms) {
        return new RuleBuilder((Collection<? extends RuleAtom>)ImmutableSet.copyOf(headAtoms));
    }

    public static RuleBuilder head(TermSet<? extends RuleAtom> headAtoms) {
        return new RuleBuilder(headAtoms);
    }

    public static Rule convert(ConstructQuery query) {
        QueryAtom aBody = query.getBody();
        Set<Axiom> aHeadAtoms = query.getConstructTemplate();
        HashSet aBodyAtoms = Sets.newHashSet();
        RuleFactory.collectRuleAtoms(aBody, aBodyAtoms);
        return RuleFactory.head(aHeadAtoms).body(aBodyAtoms);
    }

    private static void collectRuleAtoms(QueryAtom theAtom, final Set<RuleAtom> theRuleAtoms) {
        theAtom.accept(new BaseTermVisitorVoid(){

            @Override
            protected void defaultVisit(Term t) {
                theRuleAtoms.add((RuleAtom)t);
            }

            @Override
            public void visit(QueryAnd query) {
                for (QueryAtom aArg : query.getArgs()) {
                    RuleFactory.collectRuleAtoms(aArg, theRuleAtoms);
                }
            }

            @Override
            public void visit(QueryNamedGraph q) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visit(QueryNot q) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visit(QueryOr q) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

