/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl.entity;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationValue;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.builtins.AnnotationProperties;
import com.clarkparsia.pellet.api.term.entity.AnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.AnnotationPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.AnonIndividualVariable;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.DatatypeVariable;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.impl.NamedTermImpl;

public abstract class VariableImpl
extends NamedTermImpl
implements Variable {
    public VariableImpl(String name) {
        super(name);
    }

    @Override
    public final boolean isVariable() {
        return true;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Variable)) {
            return false;
        }
        return this.name.equals(((Variable)that).getName());
    }

    @Override
    public <T extends NamedEntity> T as(Class<T> entityType) {
        if (entityType.isInstance(this)) {
            return (T)this;
        }
        if (entityType.equals(ClassVariable.class)) {
            return (T)TermFactory.classVariable(this.getName());
        }
        if (entityType.equals(ObjectPropertyVariable.class)) {
            return (T)TermFactory.objectPropertyVariable(this.getName());
        }
        if (entityType.equals(DataPropertyVariable.class)) {
            return (T)TermFactory.dataPropertyVariable(this.getName());
        }
        if (entityType.equals(IndividualVariable.class)) {
            return (T)TermFactory.individualVariable(this.getName());
        }
        if (entityType.equals(AnonIndividualVariable.class)) {
            return (T)TermFactory.anonymousIndividualVariable(this.getName());
        }
        if (entityType.equals(AnnotationPropertyVariable.class)) {
            return (T)TermFactory.annotationPropertyVariable(this.getName());
        }
        if (entityType.equals(DatatypeVariable.class)) {
            return (T)TermFactory.datatypeVariable(this.getName());
        }
        throw new IllegalArgumentException("Unrecognized entity type: " + String.valueOf(entityType));
    }

    @Override
    public Declaration declaration() {
        return TermFactory.declaration(this);
    }

    @Override
    public EntityAnnotation comment(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, value);
    }

    @Override
    public EntityAnnotation comment(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, AnnotationValue value) {
        return TermFactory.annotation(this, p, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, String value) {
        return TermFactory.annotation(this, p, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public String toString() {
        return "?" + this.name;
    }
}

