/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl.entity;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationValue;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.builtins.AnnotationProperties;
import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.entity.AnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.NamedIndividual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.impl.NamedTermImpl;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

public class NamedDatatypeImpl
extends NamedTermImpl
implements NamedDatatype {
    public NamedDatatypeImpl(String name) {
        super(name);
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public <T extends NamedEntity> T as(Class<T> entityType) {
        if (entityType.isInstance(this)) {
            return (T)this;
        }
        if (entityType.equals(NamedClass.class)) {
            return (T)TermFactory.namedClass(this.getName());
        }
        if (entityType.equals(NamedObjectProperty.class)) {
            return (T)TermFactory.namedObjectProperty(this.getName());
        }
        if (entityType.equals(NamedDataProperty.class)) {
            return (T)TermFactory.namedDataProperty(this.getName());
        }
        if (entityType.equals(NamedIndividual.class)) {
            return (T)TermFactory.namedIndividual(this.getName());
        }
        if (entityType.equals(NamedAnnotationProperty.class)) {
            return (T)TermFactory.namedAnnotationProperty(this.getName());
        }
        if (entityType.equals(NamedDatatype.class)) {
            return (T)TermFactory.namedDatatype(this.getName());
        }
        throw new IllegalArgumentException("Unrecognized entity type: " + String.valueOf(entityType));
    }

    @Override
    public EntityAnnotation comment(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, value);
    }

    @Override
    public EntityAnnotation comment(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, AnnotationValue value) {
        return TermFactory.annotation(this, p, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, String value) {
        return TermFactory.annotation(this, p, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public Datatype and(Datatype c) {
        return TermFactory.dataAnd(this, c);
    }

    @Override
    public Datatype and(Datatype ... classes) {
        return TermFactory.dataAnd((Iterable<? extends Datatype>)ImmutableSet.builder().add((Object)this).add((Object[])classes).build());
    }

    @Override
    public Datatype and(Collection<? extends Datatype> classes) {
        return TermFactory.dataAnd((Iterable<? extends Datatype>)ImmutableSet.builder().add((Object)this).addAll(classes).build());
    }

    @Override
    public Datatype or(Datatype c) {
        return TermFactory.dataOr(this, c);
    }

    @Override
    public Datatype or(Datatype ... classes) {
        return TermFactory.dataOr((Iterable<? extends Datatype>)ImmutableSet.builder().add((Object)this).add((Object[])classes).build());
    }

    @Override
    public Datatype or(Collection<? extends Datatype> classes) {
        return TermFactory.dataOr((Iterable<? extends Datatype>)ImmutableSet.builder().add((Object)this).addAll(classes).build());
    }

    @Override
    public Declaration declaration() {
        return TermFactory.declaration(this);
    }

    @Override
    public DatatypeDefinition equivalentTo(Datatype definition) {
        return TermFactory.datatypeDefinition(this, definition);
    }

    @Override
    public RestrictedDatatype restrict(Facet f, LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(f, value));
    }

    @Override
    public RestrictedDatatype minInclusive(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MIN_INCLUSIVE, value));
    }

    @Override
    public RestrictedDatatype minExclusive(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MIN_EXCLUSIVE, value));
    }

    @Override
    public RestrictedDatatype maxInclusive(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MAX_INCLUSIVE, value));
    }

    @Override
    public RestrictedDatatype maxExclusive(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MAX_EXCLUSIVE, value));
    }

    @Override
    public RestrictedDatatype length(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.LENGTH, value));
    }

    @Override
    public RestrictedDatatype minLength(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MIN_LENGTH, value));
    }

    @Override
    public RestrictedDatatype maxLength(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.MAX_LENGTH, value));
    }

    @Override
    public RestrictedDatatype pattern(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.PATTERN, value));
    }

    @Override
    public RestrictedDatatype langRange(LiteralValue value) {
        return TermFactory.restrict((NamedDatatype)this, TermFactory.facetRestriction(Facets.LANG_RANGE, value));
    }
}

