/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermCollection;
import com.complexible.common.hash.HashCodeUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.Iterator;

public abstract class TermCollectionImpl<T extends Term>
implements TermCollection<T> {
    private final Collection<T> args;
    protected int hashCode = 0;

    public TermCollectionImpl(Collection<T> args) {
        Preconditions.checkNotNull(args);
        assert (args instanceof ImmutableCollection);
        this.args = args;
    }

    protected void computeHashCode() {
        this.hashCode = HashCodeUtil.hash((int)23, this.args);
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    protected abstract Class<?> termClass();

    public boolean equals(Object other) {
        if (!this.termClass().isInstance(other)) {
            return false;
        }
        TermCollection that = (TermCollection)other;
        return this.getArgs().equals(that.getArgs());
    }

    public boolean isNamed() {
        return false;
    }

    @Override
    public Collection<T> getArgs() {
        return this.args;
    }

    @Override
    public boolean contains(T term) {
        return this.args.contains(term);
    }

    @Override
    public boolean isEmpty() {
        return this.args.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getArgs().iterator();
    }

    @Override
    public int size() {
        return this.args.size();
    }

    protected String toString(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append('(');
        Joiner.on((String)", ").appendTo(builder, this.args);
        builder.append(')');
        return builder.toString();
    }
}

