/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.DNF;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.NNF;
import com.clarkparsia.pellet.api.term.builtins.Normalize;
import com.clarkparsia.pellet.api.term.builtins.Simplify;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.Type;

public class Types {
    private Types() {
    }

    public static boolean isTop(Type type) {
        return type.equals(Classes.THING) || type.equals(Datatypes.TOP);
    }

    public static boolean isBottom(Type type) {
        return type.equals(Classes.NOTHING) || type.equals(Datatypes.BOTTOM);
    }

    public static boolean isPrimitiveOrNegated(Type type) {
        return type.isNamed() || type instanceof ObjectNot && ((ObjectNot)type).getArg().isNamed() || type instanceof DataNot && ((DataNot)type).getArg().isNamed();
    }

    public static ClassExpression negate(ClassExpression c) {
        if (c instanceof ObjectNot) {
            return ((ObjectNot)c).getArg();
        }
        if (c.equals(Classes.NOTHING)) {
            return Classes.THING;
        }
        return TermFactory.not(c);
    }

    public static Datatype negate(Datatype d) {
        if (d instanceof DataNot) {
            return ((DataNot)d).getArg();
        }
        return TermFactory.dataNot(d);
    }

    public static Type negate(Type t) {
        if (t instanceof ClassExpression) {
            return Types.negate((ClassExpression)t);
        }
        if (t instanceof Datatype) {
            return Types.negate((Datatype)t);
        }
        return t;
    }

    public static ClassExpression nnf(ClassExpression c) {
        return NNF.nnf(c);
    }

    public static Datatype nnf(Datatype d) {
        return NNF.nnf(d);
    }

    public static Type nnf(Type t) {
        if (t instanceof ClassExpression) {
            return Types.nnf((ClassExpression)t);
        }
        if (t instanceof Datatype) {
            return Types.nnf((Datatype)t);
        }
        return t;
    }

    public static ClassExpression simplify(ClassExpression c) {
        return Simplify.simplify(c);
    }

    public static ClassExpression dnf(ClassExpression c) {
        return DNF.dnf(c);
    }

    public static Datatype dnf(Datatype d) {
        return DNF.dnf(d);
    }

    public static Type dnf(Type t) {
        if (t instanceof ClassExpression) {
            return Types.dnf((ClassExpression)t);
        }
        if (t instanceof Datatype) {
            return Types.dnf((Datatype)t);
        }
        return t;
    }

    public static ClassExpression normalize(ClassExpression c) {
        return Normalize.normalize(c);
    }

    public static Datatype normalize(Datatype d) {
        return d;
    }

    public static Type normalize(Type t) {
        if (t instanceof ClassExpression) {
            return Types.normalize((ClassExpression)t);
        }
        if (t instanceof Datatype) {
            return Types.normalize((Datatype)t);
        }
        return t;
    }
}

