/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.TermSet;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Types;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataProperty;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

class Simplify {
    private static final SimplifyVisitor VISITOR = new SimplifyVisitor();

    Simplify() {
    }

    public static ClassExpression simplify(ClassExpression c) {
        return c.accept(VISITOR);
    }

    private static class SimplifyVisitor
    extends BaseTermVisitor<ClassExpression> {
        private SimplifyVisitor() {
        }

        @Override
        protected ClassExpression defaultVisit(Term term) {
            assert (term instanceof ClassExpression);
            return (ClassExpression)term;
        }

        <T extends TermSet<ClassExpression>> Set<? extends ClassExpression> flatten(T termSet, ClassExpression identityElement, ClassExpression absorbingElement) {
            ArrayList<ObjectNot> negatives = new ArrayList<ObjectNot>();
            final HashSet<ClassExpression> positives = new HashSet<ClassExpression>();
            LinkedList queue = new LinkedList();
            queue.addAll(termSet.getArgs());
            while (!queue.isEmpty()) {
                ClassExpression c = (ClassExpression)queue.remove();
                if (termSet.getClass().isInstance(c)) {
                    queue.addAll(((TermSet)((Object)c)).getArgs());
                    continue;
                }
                if (c instanceof ObjectNot) {
                    negatives.add((ObjectNot)c);
                    continue;
                }
                if (c.equals(identityElement)) continue;
                positives.add(c);
            }
            Predicate<ObjectNot> negationInPositives = new Predicate<ObjectNot>(){

                public boolean apply(ObjectNot input) {
                    return positives.contains(input.getArg());
                }
            };
            if (positives.contains(absorbingElement) || Iterables.any(negatives, (Predicate)negationInPositives)) {
                return ImmutableSet.of((Object)absorbingElement);
            }
            if (positives.isEmpty()) {
                if (negatives.isEmpty()) {
                    return ImmutableSet.of((Object)identityElement);
                }
                return ImmutableSet.copyOf(negatives);
            }
            if (negatives.isEmpty()) {
                return positives;
            }
            positives.addAll(negatives);
            return positives;
        }

        @Override
        public ClassExpression visit(ClassVariable var) {
            return var;
        }

        @Override
        public ClassExpression visit(DataAll all) {
            Datatype q = all.getQualification();
            return q.equals(Datatypes.TOP) ? Classes.THING : all;
        }

        @Override
        public ClassExpression visit(DataCardinality card) {
            DataProperty p = card.getProperty();
            int n = card.getCardinality();
            Datatype q = card.getQualification();
            return n == 0 ? (q.equals(Datatypes.BOTTOM) ? Classes.THING : p.max(n, q)) : (q.equals(Datatypes.BOTTOM) ? Classes.NOTHING : card);
        }

        @Override
        public ClassExpression visit(DataHasValue value) {
            return value;
        }

        @Override
        public ClassExpression visit(DataMax max) {
            int n = max.getCardinality();
            Datatype q = max.getQualification();
            return n > 0 && q.equals(Datatypes.BOTTOM) ? Classes.THING : max;
        }

        @Override
        public ClassExpression visit(DataMin min) {
            int n = min.getCardinality();
            Datatype q = min.getQualification();
            if (n == 0) {
                return Classes.THING;
            }
            if (q.equals(Datatypes.BOTTOM)) {
                return Classes.NOTHING;
            }
            return min;
        }

        @Override
        public ClassExpression visit(DataSome some) {
            return some;
        }

        @Override
        public ClassExpression visit(NamedClass c) {
            return c;
        }

        @Override
        public ClassExpression visit(ObjectAll all) {
            ClassExpression q = Types.simplify(all.getQualification());
            return q.equals(Classes.THING) ? Classes.THING : all;
        }

        @Override
        public ClassExpression visit(ObjectAnd and) {
            Set<ClassExpression> flattened = this.flatten(and, Classes.THING, Classes.NOTHING);
            return flattened.size() == 1 ? flattened.iterator().next() : TermFactory.and(flattened);
        }

        @Override
        public ClassExpression visit(ObjectCardinality card) {
            ObjectProperty p = card.getProperty();
            int n = card.getCardinality();
            ClassExpression q = Types.simplify(card.getQualification());
            if (n == 0) {
                return q.equals(Classes.NOTHING) ? Classes.THING : p.max(n, q);
            }
            return q.equals(Classes.NOTHING) ? Classes.NOTHING : card;
        }

        @Override
        public ClassExpression visit(ObjectHasValue value) {
            return value;
        }

        @Override
        public ClassExpression visit(ObjectMax max) {
            int n = max.getCardinality();
            ClassExpression q = Types.simplify(max.getQualification());
            return n > 0 && q.equals(Classes.NOTHING) ? Classes.THING : max;
        }

        @Override
        public ClassExpression visit(ObjectMin min) {
            int n = min.getCardinality();
            ClassExpression q = Types.simplify(min.getQualification());
            if (n == 0) {
                return Classes.THING;
            }
            if (q.equals(Classes.NOTHING)) {
                return Classes.NOTHING;
            }
            return min;
        }

        @Override
        public ClassExpression visit(final ObjectNot not) {
            ClassExpression arg = not.getArg();
            BaseTermVisitor<ClassExpression> notVisitor = new BaseTermVisitor<ClassExpression>(this){

                @Override
                protected ClassExpression defaultVisit(Term c) {
                    return not;
                }

                @Override
                public ClassExpression visit(NamedClass arg) {
                    if (arg.equals(Classes.THING)) {
                        return Classes.NOTHING;
                    }
                    if (arg.equals(Classes.NOTHING)) {
                        return Classes.THING;
                    }
                    return not;
                }

                @Override
                public ClassExpression visit(ObjectMin min) {
                    return min.getCardinality() == 0 ? Classes.NOTHING : not;
                }

                @Override
                public ClassExpression visit(ObjectNot not2) {
                    return Simplify.simplify(not2.getArg());
                }
            };
            return arg.accept(notVisitor);
        }

        @Override
        public ClassExpression visit(ObjectOneOf nominal) {
            return nominal;
        }

        @Override
        public ClassExpression visit(ObjectOr or) {
            Set<ClassExpression> flattened = this.flatten(or, Classes.NOTHING, Classes.THING);
            return flattened.size() == 1 ? flattened.iterator().next() : TermFactory.or(flattened);
        }

        @Override
        public ClassExpression visit(ObjectSelf self) {
            return self;
        }

        @Override
        public ClassExpression visit(ObjectSome some) {
            ClassExpression q = Types.simplify(some.getQualification());
            return q.equals(Classes.NOTHING) ? Classes.NOTHING : some;
        }
    }
}

