/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;

public class Literals {
    public static final Literal TRUE = TermFactory.literal(true);
    public static final Literal FALSE = TermFactory.literal(false);

    private Literals() {
    }

    public static Object getValue(LiteralValue literal) {
        if (literal.isVariable()) {
            return null;
        }
        Datatype<?> dt = DatatypeReasonerImpl.coreDatatypes.get(((Literal)literal).getDatatype());
        if (dt == null) {
            return literal;
        }
        return dt.getValue((Literal)literal);
    }

    public static Boolean getBooleanValue(LiteralValue literal) {
        if (literal == null || literal.isVariable()) {
            return null;
        }
        if (TRUE == literal || TRUE.equals(literal)) {
            return true;
        }
        if (FALSE == literal || FALSE.equals(literal)) {
            return false;
        }
        Literal lit = (Literal)literal;
        NamedDatatype dt = lit.getDatatype();
        String label = lit.getLexicalValue();
        if (dt.equals(Datatypes.STRING)) {
            return label.length() > 0;
        }
        Object object = Literals.getValue(lit);
        if (object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        return null;
    }
}

