/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.google.common.collect.Maps;
import java.util.Map;

public enum Facets implements Facet
{
    MAX_EXCLUSIVE("http://www.w3.org/2001/XMLSchema#", "maxExclusive", "<"),
    MAX_INCLUSIVE("http://www.w3.org/2001/XMLSchema#", "maxInclusive", "<="),
    MIN_EXCLUSIVE("http://www.w3.org/2001/XMLSchema#", "minExclusive", ">"),
    MIN_INCLUSIVE("http://www.w3.org/2001/XMLSchema#", "minInclusive", ">="),
    LENGTH("http://www.w3.org/2001/XMLSchema#", "length"),
    MIN_LENGTH("http://www.w3.org/2001/XMLSchema#", "minLength"),
    MAX_LENGTH("http://www.w3.org/2001/XMLSchema#", "maxLength"),
    PATTERN("http://www.w3.org/2001/XMLSchema#", "pattern"),
    LANG_RANGE("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "langRange");

    private static final Map<String, Facet> MAP;
    private final String name;
    private final String localName;
    private final String symbol;

    public static Facet get(String uri) {
        return MAP.get(uri);
    }

    public static boolean isBuiltIn(Facet facet) {
        return MAP.containsKey(facet.getName());
    }

    private Facets(String nameSpace, String localName) {
        this(nameSpace, localName, localName);
    }

    private Facets(String nameSpace, String localName, String symbol) {
        this.localName = localName;
        this.name = nameSpace + localName;
        this.symbol = symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    public String toString() {
        return this.localName;
    }

    static {
        MAP = Maps.newHashMap();
        for (Facets facet : Facets.values()) {
            MAP.put(facet.getName(), facet);
        }
    }
}

