/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class Datatypes {
    private static final Map<String, NamedDatatype> MAP = Maps.newHashMap();
    public static final NamedDatatype LITERAL = Datatypes.createDatatype("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final NamedDatatype LANG_STRING = Datatypes.createDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");
    public static final NamedDatatype XML_LITERAL = Datatypes.createDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
    public static final NamedDatatype ANY_URI = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#anyURI");
    public static final NamedDatatype BASE_64_BINARY = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#base64Binary");
    public static final NamedDatatype BOOLEAN = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#boolean");
    public static final NamedDatatype BYTE = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#byte");
    public static final NamedDatatype DATE = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#date");
    public static final NamedDatatype DATE_TIME = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#dateTime");
    public static final NamedDatatype DATE_TIME_STAMP = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#dateTimeStamp");
    public static final NamedDatatype DECIMAL = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#decimal");
    public static final NamedDatatype DOUBLE = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#double");
    public static final NamedDatatype DURATION = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#duration");
    public static final NamedDatatype DAY_TIME_DURATION = TermFactory.namedDatatype("http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    public static final NamedDatatype YEAR_MONTH_DURATION = TermFactory.namedDatatype("http://www.w3.org/2001/XMLSchema#yearMonthDuration");
    public static final NamedDatatype FLOAT = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#float");
    public static final NamedDatatype G_DAY = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#gDay");
    public static final NamedDatatype G_MONTH = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#gMonth");
    public static final NamedDatatype G_MONTH_DAY = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#gMonthDay");
    public static final NamedDatatype G_YEAR = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#gYear");
    public static final NamedDatatype G_YEAR_MONTH = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#gYearMonth");
    public static final NamedDatatype HEX_BINARY = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#hexBinary");
    public static final NamedDatatype INT = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#int");
    public static final NamedDatatype INTEGER = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#integer");
    public static final NamedDatatype LANGUAGE = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#language");
    public static final NamedDatatype LONG = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#long");
    public static final NamedDatatype NAME = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#name");
    public static final NamedDatatype NCNAME = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#NCName");
    public static final NamedDatatype NEGATIVE_INTEGER = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#negativeInteger");
    public static final NamedDatatype NMTOKEN = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#NMTOKEN");
    public static final NamedDatatype NON_NEGATIVE_INTEGER = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
    public static final NamedDatatype NON_POSITIVE_INTEGER = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#nonPositiveInteger");
    public static final NamedDatatype NORMALIZED_STRING = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#normalizedString");
    public static final NamedDatatype POSITIVE_INTEGER = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#positiveInteger");
    public static final NamedDatatype RATIONAL = Datatypes.createDatatype("http://www.w3.org/2002/07/owl#rational");
    public static final NamedDatatype REAL = Datatypes.createDatatype("http://www.w3.org/2002/07/owl#real");
    public static final NamedDatatype SHORT = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#short");
    public static final NamedDatatype STRING = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#string");
    public static final NamedDatatype TIME = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#time");
    public static final NamedDatatype TOKEN = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#token");
    public static final NamedDatatype UNSIGNED_BYTE = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#unsignedByte");
    public static final NamedDatatype UNSIGNED_INT = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#unsignedInt");
    public static final NamedDatatype UNSIGNED_LONG = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#unsignedLong");
    public static final NamedDatatype UNSIGNED_SHORT = Datatypes.createDatatype("http://www.w3.org/2001/XMLSchema#unsignedShort");
    public static final NamedDatatype TOP = LITERAL;
    public static final DataNot BOTTOM = TermFactory.dataNot(LITERAL);

    private Datatypes() {
    }

    private static NamedDatatype createDatatype(String uri) {
        NamedDatatype datatype = TermFactory.namedDatatype(uri);
        MAP.put(uri, datatype);
        return datatype;
    }

    public static NamedDatatype get(String datatypeURI) {
        return MAP.get(datatypeURI);
    }

    public static boolean isBuiltIn(Datatype datatype) {
        return datatype.isNamed() && MAP.containsKey(((NamedDatatype)datatype).getName());
    }

    public static Set<NamedDatatype> getBuiltIns() {
        return ImmutableSet.copyOf(MAP.values());
    }
}

