/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query.impl;

import com.clarkparsia.pellet.api.exceptions.InconsistentOntologyException;
import com.clarkparsia.pellet.api.kb.KnowledgeBase;
import com.clarkparsia.pellet.api.query.Binding;
import com.clarkparsia.pellet.api.query.Bindings;
import com.clarkparsia.pellet.api.query.Query;
import com.clarkparsia.pellet.api.query.impl.AbstractQueryEngine;
import com.clarkparsia.pellet.api.query.impl.NestedBinding;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.axiom.AnnotationEntity;
import com.clarkparsia.pellet.api.term.axiom.AnnotationEntityVariable;
import com.clarkparsia.pellet.api.term.axiom.AnnotationValue;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.AnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.AnnotationPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.DatatypeVariable;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.LiteralVariable;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.function.BindAtom;
import com.clarkparsia.pellet.api.term.function.Expression;
import com.clarkparsia.pellet.api.term.function.FilterAtom;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.api.term.query.AtomicQueryAtom;
import com.clarkparsia.pellet.api.term.query.DatatypeAtom;
import com.clarkparsia.pellet.api.term.query.QueryAnd;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.clarkparsia.pellet.api.term.query.QueryNot;
import com.clarkparsia.pellet.api.term.query.QueryOr;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.FunctionRegistry;
import com.clarkparsia.pellet.util.Substitution;
import com.clarkparsia.pellet.util.terms.TermCollector;
import com.complexible.common.collect.NestedList;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class DefaultQueryEngine
extends AbstractQueryEngine {
    protected KnowledgeBase kb;

    public DefaultQueryEngine(KnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    protected Iterator<Binding> execute(Query<?> query, Set<Variable> selectedVars, boolean isDistinct) {
        if (query == null) {
            return ImmutableSet.of().iterator();
        }
        if (!this.kb.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        NestedList atomIt = NestedList.singleton((Object)query.getBody());
        AbstractCollection results = isDistinct ? Sets.newHashSet() : Lists.newArrayList();
        NestedBinding binding = Bindings.empty();
        this.execute((NestedList<QueryAtom>)atomIt, binding, Substitution.createSubstitution(binding), results);
        return results.iterator();
    }

    protected void execute(NestedList<QueryAtom> inputAtoms, NestedBinding currBinding, Substitution substitution, Collection<Binding> results) {
        block23: {
            Iterable<AnnotationValue> entities;
            Variable var32;
            Set<Variable> vars;
            NestedList<QueryAtom> atoms;
            block30: {
                AtomicQueryAtom atom;
                QueryAtom currentAtom;
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                DatatypeReasoner dtReasoner;
                                block25: {
                                    block24: {
                                        block22: {
                                            if (inputAtoms.isNil()) {
                                                results.add(currBinding);
                                                return;
                                            }
                                            currentAtom = (QueryAtom)inputAtoms.first();
                                            atoms = inputAtoms.rest();
                                            if (!(currentAtom instanceof QueryAnd)) break block22;
                                            Comparator annotationsLast = (a, b) -> a instanceof EntityAnnotation ? 1 : (b instanceof EntityAnnotation ? -1 : 0);
                                            ImmutableList innerAtoms = Ordering.from((Comparator)annotationsLast).immutableSortedCopy((Iterable)((QueryAnd)currentAtom));
                                            this.execute((NestedList<QueryAtom>)NestedList.concat((Iterable)innerAtoms, (NestedList)atoms), currBinding, substitution, results);
                                            break block23;
                                        }
                                        if (!(currentAtom instanceof QueryOr)) break block24;
                                        for (QueryAtom innerAtom : (QueryOr)currentAtom) {
                                            this.execute((NestedList<QueryAtom>)NestedList.create((Object)innerAtom, (NestedList)atoms), currBinding, substitution, results);
                                        }
                                        break block23;
                                    }
                                    if (!(currentAtom instanceof QueryNot)) break block25;
                                    QueryAtom innerAtom = ((QueryNot)currentAtom).getArg();
                                    ArrayList negationResults = Lists.newArrayList();
                                    this.execute((NestedList<QueryAtom>)NestedList.singleton((Object)innerAtom), currBinding, substitution, negationResults);
                                    if (!negationResults.isEmpty()) break block23;
                                    this.execute(atoms, currBinding, substitution, results);
                                    break block23;
                                }
                                if (!(currentAtom instanceof DatatypeAtom)) break block26;
                                DatatypeAtom functionAtom = (DatatypeAtom)substitution.apply(currentAtom);
                                Datatype dt = functionAtom.getDatatype();
                                LiteralValue lit = functionAtom.getLiteral();
                                if (lit.isVariable() || !(dtReasoner = this.kb.getDatatypeReasoner()).isSatisfiable(Collections.singleton(dt), dtReasoner.getValue((Literal)lit))) break block23;
                                this.execute(atoms, currBinding, substitution, results);
                                break block23;
                            }
                            if (!(currentAtom instanceof FilterAtom)) break block27;
                            FilterAtom functionFilter = (FilterAtom)currentAtom;
                            if (!this.evalBool(functionFilter.getValue(), substitution)) break block23;
                            this.execute(atoms, currBinding, substitution, results);
                            break block23;
                        }
                        if (!(currentAtom instanceof BindAtom)) break block28;
                        BindAtom functionBind = (BindAtom)currentAtom;
                        Entity entity = this.eval(functionBind.getValue(), substitution);
                        Variable var2 = functionBind.getVar();
                        Term currValue = currBinding.apply(var2);
                        if (currValue != null && !currValue.equals(entity)) break block23;
                        NestedBinding nextBinding = currBinding;
                        if (currValue == null) {
                            nextBinding = Bindings.create(currBinding, var2, entity);
                            substitution.setBinding(nextBinding);
                        }
                        this.execute(atoms, nextBinding, substitution, results);
                        if (currValue != null) break block23;
                        substitution.setBinding(currBinding);
                        break block23;
                    }
                    if (!(currentAtom instanceof EntityAnnotation)) break block29;
                    EntityAnnotation annotation = (EntityAnnotation)substitution.apply(currentAtom);
                    AnnotationEntity subject = annotation.getSubject();
                    AnnotationProperty property = annotation.getProperty();
                    AnnotationValue object = annotation.getObject();
                    for (EntityAnnotation entityAnnotation : this.kb.getAxioms(annotation)) {
                        NestedBinding nextBinding = currBinding;
                        if (subject instanceof Variable) {
                            nextBinding = Bindings.create(nextBinding, (Variable)subject, entityAnnotation.getSubject());
                        }
                        if (property instanceof Variable) {
                            nextBinding = Bindings.create(nextBinding, (Variable)((Object)property), entityAnnotation.getProperty());
                        }
                        if (object instanceof Variable) {
                            nextBinding = Bindings.create(nextBinding, (Variable)object, entityAnnotation.getObject());
                        }
                        substitution.setBinding(nextBinding);
                        this.execute(atoms, nextBinding, substitution, results);
                        substitution.setBinding(currBinding);
                    }
                    break block23;
                }
                try {
                    atom = (AtomicQueryAtom)substitution.apply(currentAtom);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                vars = TermCollector.collect((Term)atom, Variable.class);
                var32 = null;
                entities = null;
                if (vars.size() == 1) {
                    var32 = (Variable)Iterables.getOnlyElement(vars);
                    entities = var32 instanceof ClassVariable ? this.kb.selectClass(atom) : (var32 instanceof ObjectPropertyVariable ? this.kb.selectObjectProperty(atom) : (var32 instanceof DataPropertyVariable ? this.kb.selectDataProperty(atom) : (var32 instanceof IndividualVariable ? this.kb.selectIndividual(atom) : (var32 instanceof LiteralVariable ? this.kb.selectLiteral(atom) : (var32 instanceof DatatypeVariable ? this.kb.selectDatatype(atom) : (var32 instanceof AnnotationPropertyVariable ? this.kb.selectEntity(atom, AnnotationPropertyVariable.class) : (var32 instanceof AnnotationEntityVariable ? this.kb.selectEntity(atom, AnnotationEntityVariable.class) : Collections.emptySet())))))));
                } else if (vars.size() > 1) {
                    for (Variable var32 : vars) {
                        if (var32 instanceof ClassVariable) {
                            entities = this.kb.getClasses();
                        } else if (var32 instanceof ObjectPropertyVariable) {
                            entities = this.kb.getObjectProperties();
                        } else if (var32 instanceof DataPropertyVariable) {
                            entities = this.kb.getDataProperties();
                        }
                        if (entities == null) continue;
                    }
                    if (entities == null) {
                        var32 = (Variable)Iterables.tryFind(vars, (Predicate)Predicates.instanceOf(IndividualVariable.class)).orNull();
                        if (var32 == null) {
                            throw new UnsupportedOperationException("Cannot execute query atom: " + String.valueOf(currentAtom));
                        }
                        entities = this.kb.getIndividuals();
                    }
                }
                if (vars.size() != 0) break block30;
                if (!this.kb.ask(atom)) break block23;
                this.execute(atoms, currBinding, substitution, results);
                break block23;
            }
            if (vars.size() > 1) {
                atoms = inputAtoms;
            }
            for (Entity entity : entities) {
                NestedBinding nextBinding = Bindings.create(currBinding, var32, entity);
                substitution.setBinding(nextBinding);
                this.execute(atoms, nextBinding, substitution, results);
                substitution.setBinding(currBinding);
            }
        }
    }

    private Entity eval(Expression theExpression, Substitution substitution) {
        if (theExpression instanceof Entity) {
            return (Entity)theExpression;
        }
        FunctionEval functionEval = (FunctionEval)theExpression;
        FunctionEvaluator aFunctionEvaluator = FunctionRegistry.getEvaluator(functionEval.getFunction());
        return aFunctionEvaluator.eval(new FunctionArgs((Function<? super Variable, Term>)substitution, functionEval));
    }

    private boolean evalBool(Expression theExpression, Substitution substitution) {
        if (theExpression instanceof Entity) {
            return this.evalBool((Entity)theExpression);
        }
        FunctionEval functionEval = (FunctionEval)theExpression;
        FunctionEvaluator aFunctionEvaluator = FunctionRegistry.getEvaluator(functionEval.getFunction());
        return aFunctionEvaluator.evalBool(new FunctionArgs((Function<? super Variable, Term>)substitution, functionEval));
    }

    private boolean evalBool(Entity entity) {
        Boolean result;
        Boolean bl = result = entity instanceof LiteralValue ? Literals.getBooleanValue((LiteralValue)entity) : null;
        if (result == null) {
            result = false;
        }
        return result;
    }
}

