/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query;

import com.clarkparsia.pellet.api.query.AskQuery;
import com.clarkparsia.pellet.api.query.ConstructQuery;
import com.clarkparsia.pellet.api.query.ConstructQueryBuilder;
import com.clarkparsia.pellet.api.query.DescribeQuery;
import com.clarkparsia.pellet.api.query.DescribeQueryBuilder;
import com.clarkparsia.pellet.api.query.QueryBuilder;
import com.clarkparsia.pellet.api.query.SelectQuery;
import com.clarkparsia.pellet.api.query.SelectQueryBuilder;
import com.clarkparsia.pellet.api.query.impl.AskQueryImpl;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class QueryFactory {
    private QueryFactory() {
    }

    public static QueryBuilder<SelectQuery> select(Variable ... selectVars) throws IllegalArgumentException {
        return SelectQueryBuilder.createSelect(selectVars);
    }

    public static QueryBuilder<SelectQuery> select(Iterable<Variable> selectVars) throws IllegalArgumentException {
        return SelectQueryBuilder.createSelect(selectVars);
    }

    public static QueryBuilder<SelectQuery> selectDistinct(Variable ... selectVars) throws IllegalArgumentException {
        return SelectQueryBuilder.createSelectDistinct(selectVars);
    }

    public static QueryBuilder<SelectQuery> selectDistinct(Iterable<Variable> selectVars) throws IllegalArgumentException {
        return SelectQueryBuilder.createSelectDistinct(selectVars);
    }

    public static QueryBuilder<SelectQuery> selectAll() {
        return SelectQueryBuilder.createSelectAll();
    }

    public static QueryBuilder<SelectQuery> selectDistinctAll() {
        return SelectQueryBuilder.createSelectDistinctAll();
    }

    public static QueryBuilder<DescribeQuery> describe(Entity ... selectEntities) {
        return DescribeQueryBuilder.createDescribe(selectEntities);
    }

    public static QueryBuilder<DescribeQuery> describeAll() {
        return DescribeQueryBuilder.createDescribeAll();
    }

    public static AskQuery ask(QueryAtom atom) {
        AskQueryImpl query = new AskQueryImpl();
        query.setBody(atom);
        return query;
    }

    public static AskQuery ask(QueryAtom ... atoms) {
        return QueryFactory.ask((QueryAtom)TermFactory.queryAnd(atoms));
    }

    public static QueryBuilder<ConstructQuery> construct(Axiom axiom) {
        return ConstructQueryBuilder.createConstruct((Set<Axiom>)ImmutableSet.of((Object)axiom));
    }

    public static QueryBuilder<ConstructQuery> construct(Axiom ... axioms) {
        return ConstructQueryBuilder.createConstruct((Set<Axiom>)ImmutableSet.copyOf((Object[])axioms));
    }

    public static QueryBuilder<ConstructQuery> construct(Set<Axiom> axioms) {
        return ConstructQueryBuilder.createConstruct(axioms);
    }
}

