/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.kb;

import com.clarkparsia.pellet.api.exceptions.VariableNotAllowedException;
import com.clarkparsia.pellet.api.io.OntologyReaders;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.io.OntologyWriters;
import com.clarkparsia.pellet.api.kb.AxiomListener;
import com.clarkparsia.pellet.api.kb.AxiomStore;
import com.clarkparsia.pellet.api.kb.Ontology;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class MemOntology
implements Ontology {
    private String name;
    private Set<Axiom> axioms;
    private Set<Ontology> imports;
    private AxiomListenerCollection listener;

    public MemOntology() {
        this(null);
    }

    public MemOntology(String name) {
        this.name = name;
        this.axioms = Sets.newHashSet();
        this.imports = Sets.newHashSet();
        this.listener = new AxiomListenerCollection();
    }

    @Override
    public boolean add(Axiom axiom) throws VariableNotAllowedException {
        if (this.axioms.add(axiom)) {
            this.listener.axiomAdded(axiom);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Iterable<? extends Axiom> axioms) throws VariableNotAllowedException {
        boolean modified = false;
        Iterator<? extends Axiom> e = axioms.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void addImport(Ontology importedOntology) {
        this.imports.add(importedOntology);
    }

    @Override
    public void addListener(AxiomListener axiomListener) {
        this.listener.add(axiomListener);
    }

    @Override
    public void removeListener(AxiomListener axiomListener) {
        this.listener.remove(axiomListener);
    }

    @Override
    public boolean contains(Axiom axiom) {
        return this.axioms.contains(axiom);
    }

    @Override
    public Iterable<Axiom> getAxiomClosure() {
        return Iterables.concat((Iterable)Iterables.transform(this.getImportClosure(), (Function)new Function<Ontology, Iterable<Axiom>>(this){

            public Iterable<Axiom> apply(Ontology input) {
                return input.getAxioms();
            }
        }));
    }

    public Set<Axiom> getAxioms() {
        return this.axioms;
    }

    @Override
    public Set<Ontology> getImportClosure() {
        HashSet importClosure = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(this);
        while (!queue.isEmpty()) {
            Ontology ont = (Ontology)queue.remove();
            if (!importClosure.add(ont)) continue;
            queue.addAll(ont.getImports());
        }
        return importClosure;
    }

    @Override
    public Set<Ontology> getImports() {
        return this.imports;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void read(Reader reader) throws IOException {
        this.read(reader, OntologySyntax.RDF_XML);
    }

    @Override
    public void read(Reader reader, OntologySyntax syntax) throws IOException {
        OntologyReaders.create(syntax).read((AxiomStore)this, reader);
    }

    @Override
    public void read(String url) throws IOException {
        this.read(url, OntologySyntax.forFile(url));
    }

    @Override
    public void read(String url, OntologySyntax syntax) throws IOException {
        OntologyReaders.create(syntax).read((AxiomStore)this, url);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.read(in, OntologySyntax.RDF_XML);
    }

    @Override
    public void read(InputStream in, OntologySyntax syntax) throws IOException {
        OntologyReaders.create(syntax).read((AxiomStore)this, in);
    }

    @Override
    public boolean remove(Axiom axiom) {
        if (this.axioms.remove(axiom)) {
            this.listener.axiomRemoved(axiom);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Iterable<? extends Axiom> axioms) {
        boolean modified = false;
        Iterator<? extends Axiom> e = axioms.iterator();
        while (e.hasNext()) {
            if (!this.remove(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void removeImport(Ontology importedOntology) {
        this.imports.remove(importedOntology);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(writer, OntologySyntax.RDF_XML);
    }

    @Override
    public void write(Writer writer, OntologySyntax syntax) throws IOException {
        OntologyWriters.create(syntax).write((Iterable<? extends Axiom>)this.getAxioms(), writer);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(out, OntologySyntax.RDF_XML);
    }

    @Override
    public void write(OutputStream out, OntologySyntax syntax) throws IOException {
        OntologyWriters.create(syntax).write((Iterable<? extends Axiom>)this.getAxioms(), out);
    }

    private static class AxiomListenerCollection
    implements AxiomListener {
        private Set<AxiomListener> listeners = Sets.newHashSet();

        private AxiomListenerCollection() {
        }

        public void add(AxiomListener listener) {
            this.listeners.add(listener);
        }

        public void remove(AxiomListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void axiomAdded(Axiom axiom) {
            if (!this.listeners.isEmpty()) {
                for (AxiomListener listener : this.listeners) {
                    listener.axiomAdded(axiom);
                }
            }
        }

        @Override
        public void axiomRemoved(Axiom axiom) {
            if (!this.listeners.isEmpty()) {
                for (AxiomListener listener : this.listeners) {
                    listener.axiomRemoved(axiom);
                }
            }
        }
    }
}

