/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.kb;

import com.clarkparsia.pellet.api.kb.ExpressivityVisitor;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.google.common.collect.Sets;
import java.util.Set;

public class Expressivity {
    private final ExpressivityVisitor visitor;
    private boolean hasNegation = false;
    private boolean hasUnion = false;
    private boolean hasAllValues = false;
    private boolean hasDisjointClasses = false;
    private boolean hasInverse = false;
    private boolean hasFunctionality = false;
    private boolean hasCardinality = false;
    private boolean hasCardinalityQ = false;
    private boolean hasFunctionalityD = false;
    private boolean hasCardinalityD = false;
    private boolean hasSelf = false;
    private boolean hasTransitivity = false;
    private boolean hasRoleHierarchy = false;
    private boolean hasReflexivity = false;
    private boolean hasIrreflexivity = false;
    private boolean hasDisjointRoles = false;
    private boolean hasAsymmetry = false;
    private boolean hasComplexSubRoles = false;
    private boolean hasDatatype = false;
    private boolean hasUserDefinedDatatype = false;
    private boolean hasKeys = false;
    private boolean hasDomain = false;
    private boolean hasRange = false;
    private Set<Individual> nominals = Sets.newHashSet();
    private Set<NamedObjectProperty> anonInverses = Sets.newHashSet();

    public Expressivity() {
        this.visitor = new ExpressivityVisitor(this);
    }

    public Expressivity(Expressivity other) {
        this();
        this.hasNegation = other.hasNegation;
        this.hasUnion = other.hasUnion;
        this.hasAllValues = other.hasAllValues;
        this.hasDisjointClasses = other.hasDisjointClasses;
        this.hasInverse = other.hasInverse;
        this.hasFunctionality = other.hasFunctionality;
        this.hasCardinality = other.hasCardinality;
        this.hasCardinalityQ = other.hasCardinalityQ;
        this.hasFunctionalityD = other.hasFunctionalityD;
        this.hasCardinalityD = other.hasCardinalityD;
        this.hasTransitivity = other.hasTransitivity;
        this.hasRoleHierarchy = other.hasRoleHierarchy;
        this.hasSelf = other.hasSelf;
        this.hasReflexivity = other.hasReflexivity;
        this.hasIrreflexivity = other.hasIrreflexivity;
        this.hasDisjointRoles = other.hasDisjointRoles;
        this.hasAsymmetry = other.hasAsymmetry;
        this.hasComplexSubRoles = other.hasComplexSubRoles;
        this.hasDatatype = other.hasDatatype;
        this.hasUserDefinedDatatype = other.hasUserDefinedDatatype;
        this.hasKeys = other.hasKeys;
        this.hasDomain = other.hasDomain;
        this.hasRange = other.hasRange;
        this.nominals = Sets.newHashSet(other.nominals);
        this.anonInverses = Sets.newHashSet(other.anonInverses);
    }

    public Expressivity copy() {
        return new Expressivity(this);
    }

    public boolean isEL() {
        return !this.hasNegation && !this.hasUnion && !this.hasAllValues && !this.hasInverse && !this.hasFunctionality && !this.hasCardinality && !this.hasCardinalityQ && !this.hasFunctionalityD && !this.hasCardinalityD && !this.hasIrreflexivity && !this.hasDisjointRoles && !this.hasAsymmetry && !this.hasDatatype && !this.hasKeys && !this.hasSelf && this.nominals.isEmpty();
    }

    public String toString() {
        Object dl = "";
        if (this.isEL()) {
            dl = "EL";
            if (this.hasComplexSubRoles || this.hasReflexivity || this.hasDomain || this.hasRange || this.hasDisjointClasses) {
                dl = (String)dl + "+";
            } else if (this.hasRoleHierarchy) {
                dl = (String)dl + "H";
            }
        } else {
            dl = "AL";
            if (this.hasNegation) {
                dl = "ALC";
            }
            if (this.hasTransitivity) {
                dl = (String)dl + "R+";
            }
            if (((String)dl).equals("ALCR+")) {
                dl = "S";
            }
            if (this.hasComplexSubRoles) {
                dl = "SR";
            } else if (this.hasRoleHierarchy) {
                dl = (String)dl + "H";
            }
            if (this.hasNominal()) {
                dl = (String)dl + "O";
            }
            if (this.hasInverse) {
                dl = (String)dl + "I";
            }
            if (this.hasCardinalityQ) {
                dl = (String)dl + "Q";
            } else if (this.hasCardinality) {
                dl = (String)dl + "N";
            } else if (this.hasFunctionality) {
                dl = (String)dl + "F";
            }
            if (this.hasDatatype) {
                dl = this.hasKeys ? (String)dl + "(Dk)" : (String)dl + "(D)";
            }
        }
        return dl;
    }

    public boolean hasNegation() {
        return this.hasNegation;
    }

    public void setHasNegation(boolean v) {
        this.hasNegation = v;
    }

    public boolean hasUnion() {
        return this.hasUnion;
    }

    public void setHasUnion(boolean v) {
        this.hasUnion = v;
    }

    public boolean hasAllValues() {
        return this.hasAllValues;
    }

    public void setHasAllValues(boolean v) {
        this.hasAllValues = v;
    }

    public boolean hasDisjointClasses() {
        return this.hasDisjointClasses;
    }

    public void setHasDisjointClasses(boolean v) {
        this.hasDisjointClasses = v;
    }

    public boolean hasInverse() {
        return this.hasInverse;
    }

    public void setHasInverse(boolean v) {
        this.hasInverse = v;
    }

    public boolean hasFunctionality() {
        return this.hasFunctionality;
    }

    public void setHasFunctionality(boolean v) {
        this.hasFunctionality = v;
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public void setHasCardinality(boolean v) {
        this.hasCardinality = v;
    }

    public boolean hasCardinalityQ() {
        return this.hasCardinalityQ;
    }

    public void setHasCardinalityQ(boolean v) {
        this.hasCardinalityQ = v;
    }

    public boolean hasFunctionalityD() {
        return this.hasFunctionalityD;
    }

    public void setHasFunctionalityD(boolean v) {
        this.hasFunctionalityD = v;
    }

    public boolean hasCardinalityD() {
        return this.hasCardinalityD;
    }

    public void setHasCardinalityD(boolean v) {
        this.hasCardinalityD = v;
    }

    public boolean hasTransitivity() {
        return this.hasTransitivity;
    }

    public void setHasTransitivity(boolean v) {
        this.hasTransitivity = v;
    }

    public boolean hasRoleHierarchy() {
        return this.hasRoleHierarchy;
    }

    public void setHasRoleHierarchy(boolean v) {
        this.hasRoleHierarchy = v;
    }

    public boolean hasReflexivity() {
        return this.hasReflexivity;
    }

    public void setHasReflexivity(boolean v) {
        this.hasReflexivity = v;
    }

    public boolean hasIrreflexivity() {
        return this.hasIrreflexivity;
    }

    public void setHasIrreflexivity(boolean v) {
        this.hasIrreflexivity = v;
    }

    public boolean hasDisjointRoles() {
        return this.hasDisjointRoles;
    }

    public void setHasDisjointRoles(boolean v) {
        this.hasDisjointRoles = v;
    }

    public boolean hasAsymmmetry() {
        return this.hasAsymmetry;
    }

    public void setHasAsymmetry(boolean v) {
        this.hasAsymmetry = v;
    }

    public boolean hasComplexSubRoles() {
        return this.hasComplexSubRoles;
    }

    public void setHasComplexSubRoles(boolean v) {
        this.hasComplexSubRoles = v;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public void setHasDatatype(boolean v) {
        this.hasDatatype = v;
    }

    public boolean hasUserDefinedDatatype() {
        return this.hasUserDefinedDatatype;
    }

    public void setHasUserDefinedDatatype(boolean v) {
        if (v) {
            this.setHasDatatype(true);
        }
        this.hasUserDefinedDatatype = v;
    }

    public boolean hasKeys() {
        return this.hasKeys;
    }

    public void setHasKeys(boolean v) {
        if (v) {
            this.setHasDatatype(true);
        }
        this.hasKeys = v;
    }

    public boolean hasDomain() {
        return this.hasDomain;
    }

    public void setHasDomain(boolean v) {
        this.hasDomain = v;
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public void setHasRange(boolean v) {
        this.hasRange = v;
    }

    public boolean hasSelf() {
        return this.hasSelf;
    }

    public void setHasSelf(boolean v) {
        this.hasSelf = v;
    }

    public boolean hasNominal() {
        return !this.nominals.isEmpty();
    }

    public Set<Individual> getNominals() {
        return this.nominals;
    }

    public void addNominal(Individual n) {
        this.nominals.add(n);
    }

    public Set<NamedObjectProperty> getAnonInverses() {
        return this.anonInverses;
    }

    public void addAnonInverse(NamedObjectProperty p) {
        this.anonInverses.add(p);
    }

    public void updateWith(Term term) {
        term.accept(this.visitor);
    }

    public void updateWith(Iterable<? extends Term> terms) {
        for (Term term : terms) {
            term.accept(this.visitor);
        }
    }
}

