/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.io;

import com.google.common.collect.Maps;
import java.util.Map;

public final class OntologySyntax {
    public static final Map<String, OntologySyntax> REGISTRY = Maps.newHashMap();
    public static final Map<String, OntologySyntax> EXTENSIONS = Maps.newHashMap();
    private static final String NS = "http://www.w3.org/ns/formats/";
    public static final OntologySyntax MANCHESTER = OntologySyntax.create("http://www.w3.org/ns/formats/OWL_Manchester", "Manchester", "text/owl-manchester", "omn");
    public static final OntologySyntax OWL_XML = OntologySyntax.create("http://www.w3.org/ns/formats/OWL_XML", "OWL/XML", "application/owl+xml", "xml", "owx");
    public static final OntologySyntax RDF_XML = OntologySyntax.create("http://www.w3.org/ns/formats/RDF_XML", "RDF/XML", "application/rdf+xml", "rdf", "owl");
    public static final OntologySyntax TURTLE = OntologySyntax.create("http://www.w3.org/ns/formats/Turtle", "Turtle", "text/turtle", "ttl", "n3", "nt");
    public static final OntologySyntax FUNCTIONAL = OntologySyntax.create("http://www.w3.org/ns/formats/OWL_Functional", "Functional", "text/owl-functional", "ofn");
    public static final OntologySyntax TERP = OntologySyntax.create("http://www.w3.org/ns/formats/Terp", "Terp", "text/terp", "terp", "trp");
    private final String identifier;
    private final String name;
    private final String mediaType;

    public static OntologySyntax create(String identifier, String name, String mediaType, String ... extensions) {
        OntologySyntax syntax = OntologySyntax.forIdentifier(identifier);
        if (syntax == null) {
            syntax = new OntologySyntax(identifier, name, mediaType);
            REGISTRY.put(name, syntax);
            for (String extension : extensions) {
                EXTENSIONS.put(extension, syntax);
            }
        }
        return syntax;
    }

    public static OntologySyntax forIdentifier(String identifier) {
        return REGISTRY.get(identifier);
    }

    public static OntologySyntax forName(String name) {
        for (OntologySyntax syntax : REGISTRY.values()) {
            if (!syntax.getName().equals(name)) continue;
            return syntax;
        }
        return null;
    }

    public static OntologySyntax forExtension(String ext) {
        OntologySyntax syntax;
        if (ext.charAt(0) == '.') {
            ext = ext.substring(1);
        }
        return (syntax = EXTENSIONS.get(ext)) == null ? RDF_XML : syntax;
    }

    public static OntologySyntax forFile(String fileName) {
        int split = fileName.lastIndexOf(".");
        if (split > 0 && split < fileName.length() - 1) {
            return OntologySyntax.forExtension(fileName.substring(split + 1));
        }
        return RDF_XML;
    }

    private OntologySyntax(String identifier, String name, String mediaType) {
        this.identifier = identifier;
        this.name = name;
        this.mediaType = mediaType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OntologySyntax)) {
            return false;
        }
        OntologySyntax that = (OntologySyntax)obj;
        return this.name.equals(that.name);
    }

    public String toString() {
        return this.name;
    }
}

