/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.io;

import com.clarkparsia.pellet.api.io.OntologyReader;
import com.clarkparsia.pellet.api.io.OntologyReaderFactory;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.rdf.RDFOntologyReaderFactory;
import com.clarkparsia.pellet.stark.StarkGraphInput;
import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import java.util.Map;

public class OntologyReaders {
    private static final Map<OntologySyntax, OntologyReaderFactory> FACTORIES = Maps.newHashMap();

    private OntologyReaders() {
    }

    public static OntologyReader create(OntologySyntax syntax) {
        OntologyReaderFactory factory = FACTORIES.get(syntax);
        if (factory == null) {
            throw new IllegalArgumentException("No reader registered for syntax: " + String.valueOf(syntax));
        }
        return (OntologyReader)factory.create();
    }

    public static OntologyReader create(OntologySyntax syntax, Options options) {
        return (OntologyReader)FACTORIES.get(syntax).create(options);
    }

    public static void register(OntologyReaderFactory factory) {
        FACTORIES.put(factory.getSyntax(), factory);
    }

    public static void unregister(OntologyReaderFactory factory) {
        FACTORIES.remove(factory.getSyntax());
    }

    public static OntologyReaderFactory getFactory(OntologySyntax syntax) {
        return FACTORIES.get(syntax);
    }

    static {
        OntologyReaders.register(RDFOntologyReaderFactory.create(StarkGraphInput.PROVIDER, OntologySyntax.RDF_XML));
        OntologyReaders.register(RDFOntologyReaderFactory.create(StarkGraphInput.PROVIDER, OntologySyntax.TURTLE));
    }
}

