/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http;

import com.complexible.stardog.ImmutableTxInfo;
import com.complexible.stardog.TxInfo;
import com.complexible.stardog.TxStatus;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;

final class TxInfoAdapter
implements JsonDeserializer<TxInfo>,
JsonSerializer<TxInfo> {
    TxInfoAdapter() {
    }

    public TxInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject aObj = json.getAsJsonObject();
        UUID aID = UUID.fromString(aObj.getAsJsonPrimitive("id").getAsString());
        String aDb = aObj.getAsJsonPrimitive("db").getAsString();
        String aUser = aObj.getAsJsonPrimitive("user").getAsString();
        long aStartTime = aObj.getAsJsonPrimitive("startTime").getAsLong();
        JsonPrimitive aStatusRaw = aObj.getAsJsonPrimitive("status");
        TxStatus aStatus = aStatusRaw == null ? null : TxStatus.valueOf((String)aStatusRaw.getAsString().toUpperCase());
        return new ImmutableTxInfo(aID, aDb, aUser, aStartTime, aStatus);
    }

    public JsonElement serialize(TxInfo theTxInfo, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject aObj = new JsonObject();
        aObj.addProperty("id", theTxInfo.getID().toString());
        aObj.addProperty("db", theTxInfo.getDB());
        aObj.addProperty("user", theTxInfo.getUser());
        aObj.addProperty("startTime", (Number)theTxInfo.getStartTime());
        aObj.addProperty("status", theTxInfo.getStatus().toString());
        return aObj;
    }
}

