/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.json;

import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.Value;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import com.stardog.stark.query.io.json.AbstractSPARQLJSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class SPARQLJSONSelectResultWriter
extends AbstractSPARQLJSONWriter<BindingSet>
implements SelectQueryResultWriter {
    private List<String> mVars = ImmutableList.of();

    public SPARQLJSONSelectResultWriter(OutputStream theOutputStream, Options theOptions) {
        super(theOutputStream, theOptions);
    }

    public void variables(@Nonnull List<String> theVars) {
        try {
            if (!this.documentOpen) {
                this.start();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.tupleVariablesFound = true;
            this.jg.writeArrayFieldStart("vars");
            for (String nextColumn : theVars) {
                this.jg.writeString(nextColumn);
            }
            this.jg.writeEndArray();
            this.mVars = theVars;
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void handle(@Nonnull BindingSet theBindings) throws ResultWritingFailed {
        try {
            if (!this.documentOpen) {
                this.start();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Must call startQueryResult before handleSolution");
            }
            this.firstTupleWritten = true;
            this.jg.writeStartObject();
            for (String var : this.mVars) {
                Value val = theBindings.get(var);
                if (val == null) continue;
                this.jg.writeFieldName(var);
                this.writeValue(val);
            }
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    @Override
    public void end() {
        if (!this.documentOpen) {
            return;
        }
        try {
            this.endHeader();
            this.jg.writeEndArray();
            this.jg.writeEndObject();
            super.end();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    @Override
    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.JSON;
    }

    public static final class SPARQLJSONSelectResultWriterFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return QueryResultFormats.JSON;
        }

        @Nonnull
        public SPARQLJSONSelectResultWriter create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new SPARQLJSONSelectResultWriter(theOutputStream, theOptions);
        }
    }
}

