/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.clarkparsia.pellet.api.io.OntologyReaderOptions;
import com.clarkparsia.pellet.api.term.NamedTerm;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermCollection;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.axiom.DataFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.DisjointClasses;
import com.clarkparsia.pellet.api.term.axiom.DisjointDataProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointProperties;
import com.clarkparsia.pellet.api.term.axiom.EquivalentClasses;
import com.clarkparsia.pellet.api.term.axiom.EquivalentDataProperties;
import com.clarkparsia.pellet.api.term.axiom.EquivalentObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.Functional;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.PropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.PropertyRange;
import com.clarkparsia.pellet.api.term.axiom.SubClassOf;
import com.clarkparsia.pellet.api.term.builtins.Types;
import com.clarkparsia.pellet.api.term.entity.AllRestriction;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.HasValue;
import com.clarkparsia.pellet.api.term.entity.InverseObjectProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.NamedProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyList;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.entity.OneOf;
import com.clarkparsia.pellet.api.term.entity.Property;
import com.clarkparsia.pellet.api.term.entity.PropertyExpression;
import com.clarkparsia.pellet.api.term.entity.QualifiedRestriction;
import com.clarkparsia.pellet.api.term.entity.SomeRestriction;
import com.clarkparsia.pellet.api.term.entity.Type;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitorVoid;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.complexible.common.base.Objects2;
import com.complexible.stardog.icv.AxiomConstraintFilter;
import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.NodeShape;
import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.Targets;
import com.complexible.stardog.reasoning.ReasoningUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ShaclGenerator {
    public static List<Shape> convertStatements(Iterable<Statement> statements) {
        Set axioms = Sets.filter((Set)ReasoningUtils.convertToAxioms(statements, (OntologyReaderOptions.Scope)OntologyReaderOptions.Scope.SCHEMA), (Predicate)new AxiomConstraintFilter());
        return ShaclGenerator.convertAxioms(axioms);
    }

    public static List<Shape> convertAxioms(Iterable<Axiom> axioms) {
        AxiomVisitor visitor = new AxiomVisitor();
        for (Axiom axiom : axioms) {
            axiom.accept((TermVisitorVoid)visitor);
        }
        return visitor.getShapes();
    }

    private static NodeShape newShape() {
        return new NodeShape((Resource)Values.bnode());
    }

    private static PropertyShape newPropertyShape(PropertyExpression p) {
        return ShaclGenerator.newPropertyShape(ShaclGenerator.newPropertyPath(p));
    }

    private static PropertyShape newPropertyShape(PropertyPath p) {
        return new PropertyShape((Resource)Values.bnode(), p);
    }

    private static PropertyPath newPropertyPath(PropertyExpression p) {
        if (p instanceof InverseObjectProperty) {
            return PropertyPaths.inverse((PropertyPath)ShaclGenerator.newPropertyPath((PropertyExpression)((InverseObjectProperty)p).getProperty()));
        }
        if (p instanceof ObjectPropertyList) {
            List paths = ((ObjectPropertyList)p).getArgs().stream().map(ShaclGenerator::newPropertyPath).collect(Collectors.toList());
            return PropertyPaths.sequence(paths);
        }
        return PropertyPaths.predicate((IRI)ShaclGenerator.iri((Term)p));
    }

    private static Value value(Term value) {
        return value instanceof com.clarkparsia.pellet.api.term.entity.Literal ? ShaclGenerator.literal((com.clarkparsia.pellet.api.term.entity.Literal)value) : ShaclGenerator.iri(value);
    }

    private static IRI iri(Term term) {
        NamedTerm named = (NamedTerm)Objects2.castTo((Object)term, NamedTerm.class, (String)"Expecting a named term but got: %s", (Object[])new Object[]{term});
        return Values.iri((String)named.getName());
    }

    private static Literal literal(com.clarkparsia.pellet.api.term.entity.Literal literal) {
        return literal.hasLanguage() ? Values.literal((String)literal.getLexicalValue(), (String)literal.getLanguage()) : Values.literal((String)literal.getLexicalValue(), (IRI)ShaclGenerator.iri((Term)literal.getDatatype()));
    }

    public static void addTargets(Shape shape, Term term) {
        TargetGenerator gen = new TargetGenerator();
        term.accept((TermVisitorVoid)gen);
        gen.targets.forEach(arg_0 -> ((Shape)shape).addTarget(arg_0));
    }

    private static void addNodeConstraint(Shape shape, Shape node) {
        if (node instanceof PropertyShape) {
            shape.addPropertyShape((PropertyShape)node);
        } else {
            node.getConstraints().forEach(arg_0 -> ((Shape)shape).addConstraint(arg_0));
            node.getPropertyShapes().forEach(arg_0 -> ((Shape)shape).addPropertyShape(arg_0));
        }
    }

    private static class AxiomVisitor
    extends BaseTermVisitorVoid {
        private final List<Shape> shapes = Lists.newArrayList();
        private final BaseTermVisitor<Shape> visitor = new EntityVisitor();

        private AxiomVisitor() {
        }

        public List<Shape> getShapes() {
            return this.shapes;
        }

        protected void defaultVisit(Term axiom) {
            throw new UnsupportedOperationException("Cannot convert to SHACL: " + String.valueOf(axiom));
        }

        private void addShape(Shape shape) {
            this.shapes.add(shape);
        }

        public void visit(SubClassOf axiom) {
            NodeShape shape = ShaclGenerator.newShape();
            ShaclGenerator.addTargets((Shape)shape, (Term)axiom.getSub());
            Shape result = (Shape)axiom.getSuper().accept(this.visitor);
            ShaclGenerator.addNodeConstraint((Shape)shape, result);
            this.addShape((Shape)shape);
        }

        public void visit(EquivalentClasses axiom) {
            this.reduceAxiom((TermCollection)axiom, (BiFunction)ClassExpression::subClassOf);
        }

        public void visit(DisjointClasses axiom) {
            this.reduceAxiom((TermCollection)axiom, (BiFunction)(c1, c2) -> c1.subClassOf((ClassExpression)TermFactory.not((ClassExpression)c2)));
        }

        public <T extends Term> void reduceAxiom(TermCollection<T> axiom, BiFunction<T, T, Term> reducer) {
            if (axiom.size() != 2) {
                throw new UnsupportedOperationException("Cannot convert to SHACL: " + String.valueOf(axiom));
            }
            Iterator terms = axiom.iterator();
            Term t1 = (Term)terms.next();
            Term t2 = (Term)terms.next();
            reducer.apply(t1, t2).accept((TermVisitorVoid)this);
            reducer.apply(t2, t1).accept((TermVisitorVoid)this);
        }

        public void visit(DisjointObjectProperties axiom) {
            this.visitDisjointProperties((DisjointProperties)axiom);
        }

        public void visit(DisjointDataProperties axiom) {
            this.visitDisjointProperties((DisjointProperties)axiom);
        }

        public void visitDisjointProperties(DisjointProperties axiom) {
            this.handleProperties((Axiom)axiom, (Iterable<? extends Property>)axiom, false);
        }

        public void visit(EquivalentObjectProperties axiom) {
            this.handleProperties((Axiom)axiom, (Iterable<? extends Property>)axiom, true);
        }

        public void visit(EquivalentDataProperties axiom) {
            this.handleProperties((Axiom)axiom, (Iterable<? extends Property>)axiom, true);
        }

        public <T extends Property> void handleProperties(Axiom axiom, Iterable<? extends Property> properties, boolean isEquivalent) {
            Iterator<? extends Property> i = properties.iterator();
            Property p1 = i.next();
            Property p2 = i.next();
            if (i.hasNext() || !(p2 instanceof NamedProperty)) {
                throw new UnsupportedOperationException("Cannot convert to SHACL: " + String.valueOf(axiom));
            }
            Function<IRI, ConstraintComponents.ConstraintComponent> converter = isEquivalent ? ConstraintComponents.EqualsConstraintComponent::new : ConstraintComponents.DisjointConstraintComponent::new;
            this.handleProperties(p1, p2, converter);
        }

        private void handleProperties(Property p1, Property p2, Function<IRI, ConstraintComponents.ConstraintComponent> converter) {
            PropertyShape shape = ShaclGenerator.newPropertyShape((PropertyExpression)p1);
            ShaclGenerator.addTargets((Shape)shape, (Term)p1);
            shape.addConstraint(converter.apply(ShaclGenerator.iri((Term)p2)));
            this.addShape((Shape)shape);
        }

        public void visit(ObjectPropertyDomain axiom) {
            this.visitDomain((PropertyDomain)axiom);
        }

        public void visit(DataPropertyDomain axiom) {
            this.visitDomain((PropertyDomain)axiom);
        }

        public void visitDomain(PropertyDomain axiom) {
            Shape result = (Shape)axiom.getDomain().accept(this.visitor);
            NodeShape shape = ShaclGenerator.newShape();
            shape.addTarget((Targets.Target)Targets.subjectsOfTarget((IRI)ShaclGenerator.iri((Term)axiom.getProperty())));
            ShaclGenerator.addNodeConstraint((Shape)shape, result);
            this.addShape((Shape)shape);
        }

        public void visit(ObjectPropertyRange axiom) {
            this.visitRange((PropertyRange)axiom);
        }

        public void visit(DataPropertyRange axiom) {
            this.visitRange((PropertyRange)axiom);
        }

        public void visitRange(PropertyRange axiom) {
            Shape result = (Shape)axiom.getRange().accept(this.visitor);
            PropertyShape shape = ShaclGenerator.newPropertyShape((PropertyExpression)axiom.getProperty());
            shape.addTarget((Targets.Target)Targets.subjectsOfTarget((IRI)ShaclGenerator.iri((Term)axiom.getProperty())));
            ShaclGenerator.addNodeConstraint((Shape)shape, result);
            this.addShape((Shape)shape);
        }

        public void visit(ObjectFunctional axiom) {
            this.visitFunctional((Functional)axiom);
        }

        public void visit(ObjectInverseFunctional axiom) {
            this.visitFunctional((Functional)axiom.getProperty().inverse().functional());
        }

        public void visit(DataFunctional axiom) {
            this.visitFunctional((Functional)axiom);
        }

        public void visitFunctional(Functional axiom) {
            Property p = axiom.getProperty();
            PropertyShape shape = ShaclGenerator.newPropertyShape((PropertyExpression)p);
            ShaclGenerator.addTargets((Shape)shape, (Term)p);
            shape.addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.MaxCountConstraintComponent(Values.literal((int)1)));
            this.addShape((Shape)shape);
        }
    }

    private static class TargetGenerator
    extends BaseTermVisitorVoid {
        private List<Targets.Target> targets = Lists.newArrayList();

        private TargetGenerator() {
        }

        protected void defaultVisit(Term term) {
            throw new UnsupportedOperationException("Cannot convert target to SHACL: " + String.valueOf(term));
        }

        public void visit(NamedClass cls) {
            this.targets.add((Targets.Target)Targets.classTarget((IRI)ShaclGenerator.iri((Term)cls)));
        }

        public void visit(ObjectOr or) {
            for (ClassExpression cls : or) {
                cls.accept((TermVisitorVoid)this);
            }
        }

        public void visit(ObjectSome some) {
            this.handleRestriction((SomeRestriction)some);
        }

        public void visit(DataSome some) {
            this.handleRestriction((SomeRestriction)some);
        }

        private void handleRestriction(SomeRestriction restriction) {
            Type type = restriction.getQualification();
            if (!Types.isTop((Type)type)) {
                this.defaultVisit((Term)restriction);
            }
            restriction.getProperty().accept((TermVisitorVoid)this);
        }

        public void visit(NamedDataProperty p) {
            this.targets.add((Targets.Target)Targets.subjectsOfTarget((IRI)ShaclGenerator.iri((Term)p)));
        }

        public void visit(NamedObjectProperty p) {
            this.targets.add((Targets.Target)Targets.subjectsOfTarget((IRI)ShaclGenerator.iri((Term)p)));
        }

        public void visit(InverseObjectProperty inv) {
            boolean inverse = false;
            InverseObjectProperty p = inv;
            while (p instanceof InverseObjectProperty) {
                p = p.getProperty();
                inverse = !inverse;
            }
            IRI iri = ShaclGenerator.iri((Term)p);
            if (inverse) {
                this.targets.add((Targets.Target)Targets.objectsOfTarget((IRI)iri));
            } else {
                this.targets.add((Targets.Target)Targets.subjectsOfTarget((IRI)iri));
            }
        }

        public void visit(ObjectPropertyList p) {
            ((ObjectProperty)p.getFirst()).accept((TermVisitorVoid)this);
        }
    }

    private static class EntityVisitor
    extends BaseTermVisitor<Shape> {
        private ShapeContext context;

        private EntityVisitor() {
        }

        private ShapeContext<NodeShape> newNodeContext() {
            return new ShapeContext(this, (Shape)ShaclGenerator.newShape());
        }

        private ShapeContext<PropertyShape> newPropertyContext(Property p) {
            return new ShapeContext(this, (Shape)ShaclGenerator.newPropertyShape((PropertyExpression)p));
        }

        protected Shape defaultVisit(Term term) {
            throw new UnsupportedOperationException("Cannot convert to SHACL: " + String.valueOf(term));
        }

        public Shape visit(ObjectAnd axiom) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                for (ClassExpression cls : axiom) {
                    Shape result = (Shape)cls.accept((TermVisitor)this);
                    ShaclGenerator.addNodeConstraint(cxt.shape, result);
                }
                Iterator<Object> iterator = cxt.shape;
                return iterator;
            }
        }

        public Shape visit(ObjectOr axiom) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                ArrayList shapes = Lists.newArrayList();
                for (ClassExpression cls : axiom) {
                    Shape result = (Shape)cls.accept((TermVisitor)this);
                    shapes.add(result);
                }
                ((NodeShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.OrConstraintComponent((List)shapes));
                Iterator<Object> iterator = cxt.shape;
                return iterator;
            }
        }

        public Shape visit(ObjectNot axiom) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                Shape result = (Shape)axiom.getArg().accept((TermVisitor)this);
                ((NodeShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.NotConstraintComponent(result));
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(ObjectAll axiom) {
            return this.visitAllRestriction((AllRestriction)axiom);
        }

        public Shape visit(DataAll axiom) {
            return this.visitAllRestriction((AllRestriction)axiom);
        }

        public Shape visitAllRestriction(AllRestriction axiom) {
            try (ShapeContext<PropertyShape> cxt = this.newPropertyContext(axiom.getProperty());){
                Shape result = (Shape)axiom.getQualification().accept((TermVisitor)this);
                ShaclGenerator.addNodeConstraint(cxt.shape, result);
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(ObjectOneOf axiom) {
            return this.visitOneOf((OneOf<? extends Term>)axiom);
        }

        public Shape visit(DataOneOf axiom) {
            return this.visitOneOf((OneOf<? extends Term>)axiom);
        }

        public Shape visitOneOf(OneOf<? extends Term> axiom) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                List values = axiom.getArgs().stream().map(ShaclGenerator::value).collect(Collectors.toList());
                ((NodeShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.InConstraintComponent(values));
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(ObjectHasValue axiom) {
            return this.visitHasValue((HasValue)axiom);
        }

        public Shape visit(DataHasValue axiom) {
            return this.visitHasValue((HasValue)axiom);
        }

        public Shape visitHasValue(HasValue axiom) {
            try (ShapeContext<PropertyShape> cxt = this.newPropertyContext(axiom.getProperty());){
                ((PropertyShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.HasValueConstraintComponent(ShaclGenerator.value((Term)axiom.getValue())));
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(ObjectSome axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, 1, Cardinality.MIN);
        }

        public Shape visit(DataSome axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, 1, Cardinality.MIN);
        }

        public Shape visit(ObjectMin axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.MIN);
        }

        public Shape visit(DataMin axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.MIN);
        }

        public Shape visit(ObjectMax axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.MAX);
        }

        public Shape visit(DataMax axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.MAX);
        }

        public Shape visit(ObjectCardinality axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.EXACT);
        }

        public Shape visit(DataCardinality axiom) {
            return this.visitCardinality((QualifiedRestriction)axiom, axiom.getCardinality(), Cardinality.EXACT);
        }

        public Shape visitCardinality(QualifiedRestriction axiom, int count, Cardinality cardinality) {
            try (ShapeContext<PropertyShape> cxt = this.newPropertyContext(axiom.getProperty());){
                Literal lit = Values.literal((int)count);
                if (axiom.isQualified()) {
                    Shape result = (Shape)axiom.getQualification().accept((TermVisitor)this);
                    if (cardinality != Cardinality.MAX) {
                        ((PropertyShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.QualifiedMinCountConstraintComponent(lit, result));
                    }
                    if (cardinality != Cardinality.MIN) {
                        ((PropertyShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.QualifiedMaxCountConstraintComponent(lit, result));
                    }
                } else {
                    if (cardinality != Cardinality.MAX) {
                        ((PropertyShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.MinCountConstraintComponent(Values.literal((int)count)));
                    }
                    if (cardinality != Cardinality.MIN) {
                        ((PropertyShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.MaxCountConstraintComponent(Values.literal((int)count)));
                    }
                }
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(NamedClass cls) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                ((NodeShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.ClassConstraintComponent(ShaclGenerator.iri((Term)cls)));
                Object t = cxt.shape;
                return t;
            }
        }

        public Shape visit(NamedDatatype datatype) {
            try (ShapeContext<NodeShape> cxt = this.newNodeContext();){
                ((NodeShape)cxt.shape).addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.DatatypeConstraintComponent(ShaclGenerator.iri((Term)datatype)));
                Object t = cxt.shape;
                return t;
            }
        }

        private static class ShapeContext<T extends Shape>
        implements AutoCloseable {
            private ShapeContext<?> parent;
            private final T shape;
            final /* synthetic */ EntityVisitor this$0;

            private ShapeContext(T shape) {
                this.this$0 = var1_1;
                this.shape = shape;
                this.parent = var1_1.context;
                var1_1.context = this;
            }

            @Override
            public void close() {
                this.this$0.context = this.parent;
            }
        }

        static enum Cardinality {
            MIN,
            MAX,
            EXACT;

        }
    }
}

