/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.complexible.common.base.Objects2;
import com.complexible.common.base.Options;
import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.NodeShape;
import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.ShaclWriter;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.Targets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.Property;
import com.stardog.model.Type;
import com.stardog.stark.IRI;
import com.stardog.stark.OWL;
import com.stardog.stark.Resource;
import com.stardog.stark.Values;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDFS;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclDataModelWriter
implements DataModelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShaclDataModelWriter.class);

    public DataModelFormat getFormat() {
        return DataModelFormat.SHACL;
    }

    public void write(OutputStream out, DataModel model, Options options) {
        FileFormat format = (FileFormat)Preconditions.checkNotNull((Object)((FileFormat)options.get(DataModelWriterOptions.SERIALIZATION_FORMAT)), (Object)"No serialization format provided");
        RDFHandler handler = (RDFHandler)RDFWriters.to((OutputStream)out, (RDFFormat)((RDFFormat)Objects2.castTo((Object)format, RDFFormat.class, (String)"Not a valid RDF format: %s", (Object[])new Object[]{format}))).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided" + String.valueOf(format)));
        this.write(handler, model, options);
    }

    public void write(RDFHandler handler, DataModel model, Options options) {
        Iterable namespaces = (Iterable)options.get(DataModelWriterOptions.NAMESPACES);
        List<Shape> shapes = this.write(model, options);
        ShaclWriter writer = new ShaclWriter();
        shapes.forEach(arg_0 -> ((ShaclWriter)writer).writeShape(arg_0));
        handler.start();
        namespaces.forEach(ns -> handler.namespace(ns.prefix(), ns.iri()));
        handler.namespace("sh", "http://www.w3.org/ns/shacl#");
        handler.namespace("dc", "http://purl.org/dc/elements/1.1/");
        handler.namespace("model", "tag:stardog:api:model:");
        handler.namespace("dcat", "http://www.w3.org/ns/dcat#");
        handler.namespace("virtual", "virtual://");
        handler.namespace("dataService", "tag:stardog:api:model:dataService:");
        handler.namespace("serviceType", "tag:stardog:api:model:dataService:type:");
        writer.getGraph().graph().forEach(arg_0 -> ((RDFHandler)handler).handle(arg_0));
        model.getStatements().forEach(arg_0 -> ((RDFHandler)handler).handle(arg_0));
        handler.end();
    }

    public List<Shape> write(DataModel model, Options options) {
        ArrayList shapes = Lists.newArrayList();
        for (Type type : model.getTypes()) {
            if (type.isDatatype() || type.getName().equals(OWL.THING.toString())) continue;
            IRI classIRI = Values.iri((String)type.getName());
            NodeShape shape = new NodeShape((Resource)classIRI);
            shape.addTarget((Targets.Target)Targets.classTarget((IRI)classIRI));
            shapes.add(shape);
            for (Type superType : type.getSupers()) {
                shape.addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.ClassConstraintComponent(Values.iri((String)superType.getName())));
            }
            for (Property prop : type.getProperties()) {
                IRI propIRI = Values.iri((String)prop.getName());
                PropertyShape propShape = new PropertyShape((Resource)Values.bnode(), (PropertyPath)PropertyPaths.predicate((IRI)propIRI));
                shape.addPropertyShape(propShape);
                Type range = prop.getRange().orElse(null);
                if (range != null) {
                    IRI rangeIRI = Values.iri((String)range.getName());
                    Object constraint = rangeIRI.equals((Object)RDFS.LITERAL) ? new ConstraintComponents.NodeKindConstraintComponent(ConstraintComponents.NodeKind.LITERAL) : (rangeIRI.equals((Object)OWL.THING) ? new ConstraintComponents.NodeKindConstraintComponent(ConstraintComponents.NodeKind.BLANK_NODE_OR_IRI) : (range.isDatatype() ? new ConstraintComponents.DatatypeConstraintComponent(rangeIRI) : new ConstraintComponents.ClassConstraintComponent(rangeIRI)));
                    propShape.addConstraint((ConstraintComponents.ConstraintComponent)constraint);
                }
                if (prop.getMinCardinality().isPresent()) {
                    propShape.addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.MinCountConstraintComponent(prop.getMinCardinality().getAsInt()));
                }
                if (!prop.getMaxCardinality().isPresent()) continue;
                propShape.addConstraint((ConstraintComponents.ConstraintComponent)new ConstraintComponents.MaxCountConstraintComponent(prop.getMaxCardinality().getAsInt()));
            }
        }
        return shapes;
    }
}

