/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.icv.AbstractConstraint;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ConstraintFactory;
import com.google.common.collect.Lists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ICV {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ICV.class);
    public static final String PERMISSION_ICV = "icv-constraints";

    private ICV() {
        throw new AssertionError();
    }

    public static Collection<Statement> toStatements(Constraint theConstraint) {
        if (theConstraint instanceof AbstractConstraint) {
            return ((AbstractConstraint)theConstraint).toStatements();
        }
        throw new IllegalArgumentException();
    }

    public static Set<Constraint> constraintsFromGraph(Iterable<Statement> theGraph) throws StardogException {
        return ConstraintFactory.constraints(theGraph);
    }

    public static StatementSource constraintsToSource(Iterable<Constraint> theConstraints) {
        return ICV.constraintsToSource(theConstraints, null);
    }

    public static StatementSource constraintsToSource(Iterable<Constraint> theConstraints, Resource theContext) {
        ArrayList aGraph = Lists.newArrayList();
        for (Constraint aConstraint : theConstraints) {
            for (Statement aStmt : ICV.toStatements(aConstraint)) {
                aGraph.add(aStmt);
            }
        }
        return MemoryStatementSource.of((Iterable)aGraph, (Resource)theContext);
    }
}

