/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ValidationOptions;
import com.complexible.stardog.icv.ValidationReporter;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFHandler;
import java.util.Collection;

public abstract class AbstractValidationReporter
implements ValidationReporter {
    private final Options options = Options.create();

    @Override
    public ValidationReporter countLimit(int limit) {
        if (limit >= 1) {
            this.options.set(ValidationOptions.COUNT_LIMIT, (Object)limit);
            return this;
        }
        if (limit == -1) {
            this.options.set(ValidationOptions.COUNT_LIMIT, (Object)Integer.MAX_VALUE);
            return this;
        }
        throw new IllegalArgumentException("You must specify a limit greater than 0 or equal to -1 to return all violations");
    }

    @Override
    public ValidationReporter graphs(Collection<IRI> graphs) {
        this.options.set(ValidationOptions.GRAPHS, graphs);
        return this;
    }

    @Override
    public ValidationReporter shapes(Collection<IRI> shapes) {
        this.options.set(ValidationOptions.SHAPES, shapes);
        return this;
    }

    @Override
    public ValidationReporter shapeGraphs(Collection<IRI> shapeGraphs) {
        this.options.set(ValidationOptions.SHAPE_GRAPHS, shapeGraphs);
        return this;
    }

    @Override
    public ValidationReporter constraints(Collection<Constraint> constraints) {
        this.options.set(ValidationOptions.CONSTRAINTS, constraints);
        return this;
    }

    @Override
    public ValidationReporter nodes(Collection<Value> nodes) {
        this.options.set(ValidationOptions.NODES, nodes);
        return this;
    }

    @Override
    public StatementIterator report() throws StardogException {
        return this.report(this.options);
    }

    @Override
    public <T> ValidationReporter option(Option<T> option, T value) {
        this.options.set(option, value);
        return this;
    }

    @Override
    public ValidationReporter options(Options options) {
        this.options.setAll(options);
        return this;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public CloseableIterator<ValidationResult> results() {
        return this.results(this.options);
    }

    @Override
    public void report(RDFHandler handler) throws StardogException {
        this.report(this.options, handler);
    }

    protected void report(Options options, RDFHandler handler) {
        try (StatementIterator it = this.report(options);){
            handler.start();
            while (it.hasNext()) {
                handler.handle((Statement)it.next());
            }
            handler.end();
        }
    }

    protected abstract StatementIterator report(Options var1);

    protected abstract CloseableIterator<ValidationResult> results(Options var1);
}

