/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.cache.cli;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cache.CacheTarget;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import jakarta.inject.Inject;
import java.io.OutputStream;
import java.util.List;

@Command(name="target", description="List, add or remove cache targets.", examples={"* Lists the existing cache targets", "    $ stardog-admin cache target list", "", "* Adds a new cache target", "    $ stardog-admin cache target add node1 mynode.mydomain:5820 user pass", "", "* Remove a cache target and destroy its contents", "    $ stardog-admin cache target remove node1", "", "* Orphan a cache target but do not destroy the contents", "    $ stardog-admin cache target orphan node1", "", "* Add a cache target that uses an existing cache database", "    $ stardog-admin cache target add node1 mynode.mydomain:5820 user pass --use-existing-database"})
public class CacheTargetCommand
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="The hostname (optionally including port, default=5820), username and password of the cache target.", title={"hostnameAndPort", "username", "password"})
    public List<String> mArgs = Lists.newArrayList();
    @Option(name={"--use-existing-database"}, title="use existing cache database", description="Check for an existing cache database to use before creating a new one.")
    public boolean mUseExistingDatabase = false;

    @Inject
    public CacheTargetCommand(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        CacheAdminConnection cacheConn = (CacheAdminConnection)theConn.as(CacheAdminConnection.class);
        String action = this.mArgs.get(0);
        if (action == null) {
            throw new IllegalArgumentException("An action is required.");
        }
        if (action.toLowerCase().equals("list")) {
            TextTabularOutput table = new TextTabularOutput((OutputStream)System.out, new String[]{"Name", "Hostname", "Port"});
            cacheConn.getTargets().forEach(ct -> table.addRow(new Object[]{ct.getName(), ct.getHostname(), ct.getPort()}));
            table.output();
        } else if (action.toLowerCase().equals("add")) {
            String hostname;
            Preconditions.checkArgument((this.mArgs.size() == 5 ? 1 : 0) != 0, (Object)"add requires the arguments <name> <host:port> <username> <password>");
            String targetName = this.mArgs.get(1);
            String hostnameAndPort = this.mArgs.get(2);
            String username = this.mArgs.get(3);
            String password = this.mArgs.get(4);
            int port = 5820;
            if (hostnameAndPort.contains(":")) {
                String[] split = hostnameAndPort.split(":");
                Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)"Invalid hostname and port");
                hostname = split[0];
                try {
                    port = Integer.valueOf(split[1]);
                }
                catch (NumberFormatException theE) {
                    throw new IllegalArgumentException("Invalid port");
                }
            } else {
                hostname = hostnameAndPort;
            }
            CacheTarget ct2 = new CacheTarget(this, targetName, hostname, port, username, password){};
            cacheConn.addTarget(ct2, this.mUseExistingDatabase);
            System.out.println("Target added");
        } else if (action.toLowerCase().equals("remove")) {
            Preconditions.checkArgument((this.mArgs.size() == 2 ? 1 : 0) != 0, (Object)"remove requires the arguments <target name>");
            String targetName = this.mArgs.get(1);
            cacheConn.removeTarget(targetName);
            System.out.println("Target removed");
        } else if (action.toLowerCase().equals("orphan")) {
            Preconditions.checkArgument((this.mArgs.size() == 2 ? 1 : 0) != 0, (Object)"orphan requires the arguments <target name>");
            String targetName = this.mArgs.get(1);
            cacheConn.orphanTarget(targetName);
            System.out.println("Target orphaned");
        } else {
            throw new IllegalArgumentException(String.format("The command %s is not known", action));
        }
    }
}

