/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.cache.cli;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import jakarta.inject.Inject;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

@Command(name="status", description="Query the status of a cached dataset.", examples={"* Print the status of a cached dataset by name", "    $ stardog-admin cache status cache://virtual-name", "", "* Print the status of all cached datasets", "    $ stardog-admin cache status -a"})
public class CacheStatusCommand
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="The IRI used to identify the cached dataset for which to return the status.", title={"name"})
    public List<String> mArgs = Lists.newArrayList();
    @Option(name={"-a", "--all"}, title="all cached datasets", description="Return status of all cached datasets")
    public boolean mAll = false;
    private TextTabularOutput mTable = new TextTabularOutput((OutputStream)System.out, new Column[]{Columns.string((String)"Name"), Columns.string((String)"Target"), Columns.string((String)"Approx. Size", (AlignType)AlignType.TOP_RIGHT), Columns.string((String)"Last Refreshed")});

    @Inject
    public CacheStatusCommand(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        List statuses;
        CacheAdminConnection cacheConn = (CacheAdminConnection)theConn.as(CacheAdminConnection.class);
        if (this.mAll) {
            statuses = cacheConn.cacheStatus(Collections.emptyList());
        } else {
            Preconditions.checkArgument((this.mArgs.size() > 0 ? 1 : 0) != 0, (Object)"A cached dataset name or the --all flag must be provided");
            statuses = cacheConn.cacheStatus((Iterable)Lists.transform(this.mArgs, Values::iri));
        }
        statuses.forEach(status -> this.mTable.addRow(new Object[]{status.getName(), status.getTargetName(), status.getSize() < 0L ? "N/A" : Long.valueOf(status.getSize()), status.getLastRefreshed()}));
        this.mTable.output();
    }
}

