/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.cache.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import jakarta.inject.Inject;
import java.util.List;

@Command(name="refresh", description="Refresh a cached dataset.", examples={"* Refresh a cached graph by name", "    $ stardog-admin cache refresh cache://virtual-name"})
public class CacheRefreshCommand
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="The IRI used to identify the cached dataset which will be refreshed.", title={"name"})
    public List<String> mArgs = Lists.newArrayList();

    @Inject
    public CacheRefreshCommand(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        CacheAdminConnection cacheConn = (CacheAdminConnection)theConn.as(CacheAdminConnection.class);
        String msg = cacheConn.refreshCache(Values.iri((String)this.mArgs.get(0)));
        System.out.println(msg);
    }
}

