/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.cache.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import jakarta.inject.Inject;
import java.util.List;

@Command(name="drop", description="Drop a cached dataset.", examples={"* Drop a cached dataset by name", "    $ stardog-admin cache drop cache://virtual-name"})
public class CacheDropCommand
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="The IRI used to identify the cached dataset which will be dropped.", title={"name"})
    public List<String> mArgs = Lists.newArrayList();

    @Inject
    public CacheDropCommand(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        CacheAdminConnection cacheConn = (CacheAdminConnection)theConn.as(CacheAdminConnection.class);
        cacheConn.dropCache(Values.iri((String)this.mArgs.get(0)));
        System.out.println("Dropped cached dataset");
    }
}

