/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.cache.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.ParameterizedQueryCommand;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.common.collect.Lists;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="create", description="Create a new cached dataset from a virtual graph.", discussion="A cached graph duplicates the entire contents of the graph in the cache. The cached results will only be considered for use in queries against the database associated with the graph.", examples={"* Created a cached graph containing the contents of a virtual graph (assuming node1 is a registered cache target)", "    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1", "", "* Create a cached graph but do not load the contents", "    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1 --register-only", "", "* Use external compute to create a cached graph containing the contents of a virtual graph (assuming node1 is a registered cache target)", "    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1 --compute external_compute_datasource_name", ""})
public class CacheCreateCommand
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="The IRI used to identify the created cached dataset.", title={"name"})
    public List<String> mArgs = Lists.newArrayList();
    @Option(name={"-g", "--graph"}, title="graphName", description="Caches a graph with the given name.", required=true)
    public String mGraph = null;
    @Option(name={"-t", "--target"}, title="target", description="Cache target on which to store the cached dataset.The name 'localhost' can be used to cache locally.")
    public String mTarget = "localhost";
    @Option(name={"-d", "--database"}, title="database", description="Database associated with the cached dataset.")
    public String mDatabase = null;
    @Option(name={"--refresh-script"}, title="refresh script", description="Refresh script used to refresh the cached dataset.")
    public String mRefreshScriptArg = null;
    @Option(name={"--register-only"}, title="register a cached dataset only", description="Register a cached dataset without loading data from the source graph into the cache target's database.")
    public boolean mRegisterOnly = false;
    @Option(name={"-c", "--compute"}, title="compute source", description="The external compute source for the cache creation. If provided, the cache creation will run on compute platform and will write the results to the Stardog. The compute source should be the name of the data source when the external compute platform is Databricks. For emr-serverless as an external compute platform, this should be the file path containing the required properties for emr-serverless.")
    public String mComputeSource;
    @Option(name={"-pc", "--partition-column"}, title="partition column", description="The name of the partition column, to be specified if Virtual Graph is based on JDBC connection when using external compute.")
    public String mPartitionColumn;

    @Inject
    public CacheCreateCommand(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        CacheAdminConnection cacheConn = (CacheAdminConnection)theConn.as(CacheAdminConnection.class);
        String refreshScript = null;
        if (this.mRefreshScriptArg != null) {
            refreshScript = ParameterizedQueryCommand.readQueryString(null, (String)this.mRefreshScriptArg);
        }
        if (this.mGraph != null) {
            File computeFile;
            if (this.mComputeSource != null && (computeFile = new File(this.mComputeSource)).isFile()) {
                try {
                    this.mComputeSource = Files.lines(Paths.get(this.mComputeSource, new String[0])).collect(Collectors.joining(";"));
                }
                catch (IOException | RuntimeException e) {
                    throw new CliException("Error reading compute properties file '" + computeFile.getAbsolutePath() + "'. " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Cached dataset creation requires --graph as source");
        }
        String msg = cacheConn.cacheGraph(Values.iri((String)this.mArgs.get(0)), this.mDatabase, refreshScript, this.mTarget, Values.iri((String)this.mGraph), this.mRegisterOnly, this.mComputeSource, this.mPartitionColumn);
        System.out.println("msg:: " + msg);
    }
}

