/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.admin.pack;

import com.complexible.stardog.StardogException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class StateMachine<S extends Enum, E extends Enum, O> {
    protected final Map<S, Map<E, StateTransition>> mTransitions = new HashMap<S, Map<E, StateTransition>>();
    protected S mCurrentState;
    protected StateTransition mCurrentTransition = null;

    public StateMachine(S theFirstState) {
        this.mCurrentState = theFirstState;
    }

    public void addTransition(S theStartState, E theEvent, S theNextState, Consumer<StateTransition> theTransitionConsumer, O theUserObject) {
        if (!this.mTransitions.containsKey(theStartState)) {
            HashMap aMap = new HashMap();
            this.mTransitions.put(theStartState, aMap);
        }
        StateTransition aStateTransition = new StateTransition(this, theNextState, theTransitionConsumer, theUserObject);
        Map<E, StateTransition> aEventMap = this.mTransitions.get(theStartState);
        if (aEventMap.containsKey(theEvent)) {
            throw new StardogException(String.format("The transition from %s to %s for the event %s already exists", ((Enum)theStartState).name(), ((Enum)theNextState).name(), ((Enum)theEvent).name()));
        }
        aEventMap.put(theEvent, aStateTransition);
    }

    public void eventOccurred(E theEvent) {
        Map<E, StateTransition> aEventMap = this.mTransitions.get(this.mCurrentState);
        if (aEventMap == null) {
            throw new StardogException(String.format("Event %s is not allowed when in state %s", ((Enum)theEvent).name(), ((Enum)this.mCurrentState).name()));
        }
        this.mCurrentTransition = aEventMap.get(theEvent);
        if (this.mCurrentTransition == null) {
            throw new StardogException(String.format("Event %s is not allowed when in state %s", ((Enum)theEvent).name(), ((Enum)this.mCurrentState).name()));
        }
        try {
            if (this.mCurrentTransition.mLogic != null) {
                this.mCurrentTransition.mLogic.accept(this.mCurrentTransition);
            }
            this.mCurrentState = this.mCurrentTransition.getNextState();
        }
        finally {
            this.mCurrentTransition = null;
        }
    }

    public S getCurrentState() {
        return this.mCurrentState;
    }

    public class StateTransition {
        protected final Consumer<StateTransition> mLogic;
        protected final S mNextState;
        protected final O mUserObject;

        /*
         * WARNING - Possible parameter corruption
         */
        StateTransition(S theState, Consumer theMethod, O theUserObject) {
            this.mNextState = theState;
            this.mLogic = theMethod;
            this.mUserObject = theUserObject;
        }

        public S getNextState() {
            return this.mNextState;
        }

        public O getUserObject() {
            return this.mUserObject;
        }
    }
}

