/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl.sesame;

import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.TriplesMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class StarkConfiguration
implements LibConfiguration {
    private Class<Resource> res = Resource.class;
    private Class<Statement> trpl = Statement.class;
    private Class<Set> graph = Set.class;

    public Resource createResource(String URI) {
        return Values.iri((String)URI);
    }

    public Resource createBNode() {
        return Values.bnode();
    }

    public Statement createTriple(Object subject, Object predicate, Object object) {
        return Values.statement((Resource)((Resource)subject), (IRI)((IRI)predicate), (Value)((Resource)object));
    }

    public Statement createLiteralTriple(Object subject, Object predicate, String litObject) {
        return Values.statement((Resource)((Resource)subject), (IRI)((IRI)predicate), (Value)Values.literal((String)litObject));
    }

    @Override
    public Set<Statement> createGraph(Collection<TriplesMap> maps) {
        HashSet m = Sets.newHashSet();
        for (TriplesMap tm : maps) {
            m.addAll(tm.serialize(Statement.class));
        }
        return m;
    }

    public Resource getRDFType() {
        return RDF.TYPE;
    }

    @Override
    public Collection<Object> getSubjects(Object graph, Object pred, Object obj) {
        return ((Set)graph).stream().filter(Statements.matches(null, (IRI)((IRI)pred), (Value)((Value)obj), (Resource[])new Resource[]{null})).map(Statement::subject).collect(Collectors.toSet());
    }

    @Override
    public Collection<Object> getObjects(Object graph, Object subj, Object pred) {
        HashSet<Object> c = new HashSet<Object>();
        ((Set)graph).stream().filter(Statements.matches((Resource)((Resource)subj), (IRI)((IRI)pred), null, (Resource[])new Resource[]{null})).map(Statement::object).forEach(v -> {
            if (v instanceof Literal) {
                Literal l = (Literal)v;
                c.add(l.label());
            } else {
                c.add(v);
            }
        });
        return c;
    }

    @Override
    public Collection<Object> getObjectsAsValues(Object graph, Object subj, Object pred) {
        HashSet<Object> c = new HashSet<Object>();
        ((Set)graph).stream().filter(Statements.matches((Resource)((Resource)subj), (IRI)((IRI)pred), null, (Resource[])new Resource[]{null})).map(Statement::object).forEach(c::add);
        return c;
    }

    public Class<Resource> getResourceClass() {
        return this.res;
    }

    public Class<Statement> getTripleClass() {
        return this.trpl;
    }

    public Class<Set> getGraphClass() {
        return this.graph;
    }

    @Override
    public String getLexicalForm(Object node) {
        return node instanceof Value ? Value.lex((Value)((Value)node)) : node.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.trpl == null ? 0 : this.trpl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StarkConfiguration)) {
            return false;
        }
        StarkConfiguration other = (StarkConfiguration)obj;
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.trpl == null ? other.trpl != null : !this.trpl.equals(other.trpl));
    }
}

