/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.InverseExpression;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.TermMap;
import java.util.HashSet;
import java.util.Set;

public abstract class TermMapImpl
implements TermMap {
    TermMap.TermMapType type;
    Object termtype;
    Template template;
    String constVal;
    String columnName;
    InverseExpression inverseExp;
    Object res;
    final LibConfiguration lc;

    public TermMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, Template template) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        if (termMapType == null) {
            throw new NullPointerException("A TermMap must have a TermMapType.");
        }
        if (template == null) {
            throw new NullPointerException("A template-valued TermMap must have a Template.");
        }
        if (termMapType != TermMap.TermMapType.TEMPLATE_VALUED) {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.type = termMapType;
        this.setDefaultTermType();
        this.setTemplate(template);
        this.setResource(this.lc.createBNode());
    }

    public TermMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, String columnOrConst) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        if (termMapType == null) {
            throw new NullPointerException("The TermMapType is null.");
        }
        if (columnOrConst == null) {
            throw new NullPointerException("ColumnOrConst is null.");
        }
        this.type = termMapType;
        this.setDefaultTermType();
        this.setResource(this.lc.createBNode());
        if (this.getTermMapType() == TermMap.TermMapType.COLUMN_VALUED) {
            this.setColumn(columnOrConst);
        } else if (this.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
            this.setConstant(columnOrConst);
        } else {
            throw new IllegalStateException("Wrong TermMapType");
        }
    }

    @Override
    public TermMap.TermMapType getTermMapType() {
        return this.type;
    }

    @Override
    public void setTemplate(Template template) {
        if (this.getTermMapType() == TermMap.TermMapType.TEMPLATE_VALUED) {
            if (template == null) {
                throw new NullPointerException("A template-valued TermMap must have a Template.");
            }
        } else {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.template = template;
    }

    @Override
    public void setConstant(String constVal) {
        if (this.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
            if (constVal == null) {
                throw new NullPointerException("A constant-valued TermMap must have a value.");
            }
        } else {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.constVal = constVal;
    }

    @Override
    public void setColumn(String columnName) {
        if (this.getTermMapType() == TermMap.TermMapType.COLUMN_VALUED) {
            if (columnName == null) {
                throw new NullPointerException("A column-valued TermMap must have a column name.");
            }
        } else {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.columnName = columnName;
    }

    @Override
    public void setInverseExpression(InverseExpression invExp) {
        if (this.getTermMapType() != TermMap.TermMapType.COLUMN_VALUED && this.getTermMapType() != TermMap.TermMapType.TEMPLATE_VALUED) {
            throw new IllegalStateException("Wrong TermMapType");
        }
        this.inverseExp = invExp;
    }

    @Override
    public void setDefaultTermType() {
        this.termtype = this.lc.createResource("http://www.w3.org/ns/r2rml#IRI");
    }

    @Override
    public <R> R getTermType(Class<R> resourceClass) {
        return resourceClass.cast(this.termtype);
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public String getTemplateString() {
        return this.template.toString();
    }

    @Override
    public String getConstant() {
        return this.constVal;
    }

    @Override
    public String getColumn() {
        return this.columnName;
    }

    @Override
    public InverseExpression getInverseExpression() {
        return this.inverseExp;
    }

    @Override
    public String getInverseExpressionString() {
        return this.inverseExp.toString();
    }

    @Override
    public void removeInverseExpression() {
        this.inverseExp = null;
    }

    @Override
    public void setResource(Object r) {
        if (r != null && !this.lc.getResourceClass().isInstance(r)) {
            throw new IllegalArgumentException("Parameter r is of type " + String.valueOf(r.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        if (r == null) {
            throw new NullPointerException("A TermMap must have a resource.");
        }
        this.res = r;
    }

    @Override
    public <R> R getResource(Class<R> resourceClass) {
        return resourceClass.cast(this.res);
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#TermMap"))));
        if (this.type == TermMap.TermMapType.COLUMN_VALUED) {
            stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#column"), this.getColumn())));
        } else if (this.type == TermMap.TermMapType.CONSTANT_VALUED) {
            stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#constant"), this.getConstant())));
        } else if (this.type == TermMap.TermMapType.TEMPLATE_VALUED) {
            stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#template"), this.getTemplateString())));
        }
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#termType"), this.termtype)));
        if (this.getInverseExpression() != null) {
            stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#inverseExpression"), this.getInverseExpressionString())));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.constVal == null ? 0 : this.constVal.hashCode());
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.termtype == null ? 0 : this.termtype.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermMapImpl)) {
            return false;
        }
        TermMapImpl other = (TermMapImpl)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.constVal == null ? other.constVal != null : !this.constVal.equals(other.constVal)) {
            return false;
        }
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        if (this.termtype == null ? other.termtype != null : !this.termtype.equals(other.termtype)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "TermMapImpl [type=" + String.valueOf((Object)this.type) + ", termtype=" + String.valueOf(this.termtype) + ", template=" + String.valueOf(this.template) + ", constVal=" + this.constVal + ", columnName=" + this.columnName + ", inverseExp=" + String.valueOf(this.inverseExp) + ", res=" + String.valueOf(this.res) + "]";
    }
}

