/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import com.google.common.collect.Lists;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.impl.R2RMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class TemplateImpl
implements Template {
    private ArrayList<String> segList;
    private ArrayList<String> colList;

    public TemplateImpl() {
        this.segList = new ArrayList();
        this.colList = new ArrayList();
    }

    public TemplateImpl(List<String> segList, List<String> colList) {
        this.segList = Lists.newArrayList(segList);
        this.colList = Lists.newArrayList(colList);
    }

    public TemplateImpl(String template) {
        this.segList = new ArrayList();
        this.colList = new ArrayList();
        char[] chars = template.toCharArray();
        boolean braceFound = false;
        int prev = 0;
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{' && !R2RMLUtil.isEscaped(i, chars)) {
                if (!braceFound) {
                    braceFound = true;
                    this.addStringSegment(index, template.substring(prev, i));
                    prev = i + 1;
                    continue;
                }
                throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
            }
            if (chars[i] != '}' || R2RMLUtil.isEscaped(i, chars)) continue;
            if (braceFound) {
                braceFound = false;
                this.addColumnName(index++, template.substring(prev, i));
                prev = i + 1;
                continue;
            }
            throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
        }
        if (braceFound) {
            throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
        }
        if (chars[chars.length - 1] != '}' || R2RMLUtil.isEscaped(chars.length - 1, chars)) {
            this.addStringSegment(index, template.substring(prev, chars.length));
        }
    }

    @Override
    public String getStringSegment(int segIndex) {
        return this.segList.get(segIndex);
    }

    @Override
    public void addStringSegment(int segIndex, String segment) {
        if (segIndex < this.segList.size()) {
            this.segList.set(segIndex, segment);
        } else {
            this.segList.add(segIndex, segment);
        }
    }

    public List<String> getStringSegments() {
        return Collections.unmodifiableList(this.segList);
    }

    @Override
    public String getColumnName(int colIndex) {
        return this.colList.get(colIndex);
    }

    @Override
    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.colList);
    }

    @Override
    public void addColumnName(int colIndex, String columnName) {
        if (colIndex < this.colList.size()) {
            this.colList.set(colIndex, columnName);
        } else {
            this.colList.add(colIndex, columnName);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colList == null ? 0 : this.colList.hashCode());
        result = 31 * result + (this.segList == null ? 0 : this.segList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl other = (TemplateImpl)obj;
        if (this.colList == null ? other.colList != null : !this.colList.equals(other.colList)) {
            return false;
        }
        return !(this.segList == null ? other.segList != null : !this.segList.equals(other.segList));
    }

    public String toString() {
        ListIterator<String> segIt = this.segList.listIterator();
        ListIterator<String> colIt = this.colList.listIterator();
        StringBuilder sb = new StringBuilder();
        while (segIt.hasNext()) {
            sb.append((String)segIt.next());
            if (!colIt.hasNext()) break;
            sb.append("{" + (String)colIt.next() + "}");
        }
        return sb.toString();
    }
}

