/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.impl.TermMapImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SubjectMapImpl
extends TermMapImpl
implements SubjectMap {
    ArrayList<Object> classList = new ArrayList();
    ArrayList<GraphMap> graphList = new ArrayList();

    public SubjectMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, Template template) {
        super(c, termMapType, template);
    }

    public SubjectMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, String columnOrConst) {
        super(c, termMapType, columnOrConst);
    }

    @Override
    public void addClass(Object classURI) {
        if (classURI != null && !this.lc.getResourceClass().isInstance(classURI)) {
            throw new IllegalArgumentException("Parameter classURI is of type " + String.valueOf(classURI.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        this.classList.add(classURI);
    }

    @Override
    public void addGraphMap(GraphMap gm) {
        this.graphList.add(gm);
    }

    @Override
    public void addGraphMap(List<GraphMap> gms) {
        this.graphList.addAll(gms);
    }

    @Override
    public void setTermType(Object typeURI) {
        if (typeURI != null && !this.lc.getResourceClass().isInstance(typeURI)) {
            throw new IllegalArgumentException("Parameter typeURI is of type " + String.valueOf(typeURI.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        if (typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#IRI")) || typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#BlankNode"))) {
            if (this.type != TermMap.TermMapType.COLUMN_VALUED && this.type != TermMap.TermMapType.TEMPLATE_VALUED) {
                throw new IllegalStateException("The term type can only be set for column and template valued SubjectMaps.");
            }
        } else {
            throw new IllegalArgumentException("The typeIRI is not a valid term type IRI for a SubjectMap.");
        }
        this.termtype = typeURI;
    }

    @Override
    public <R> R getClass(Class<R> resourceClass, int index) {
        return resourceClass.cast(this.classList.get(index));
    }

    @Override
    public GraphMap getGraphMap(int index) {
        return this.graphList.get(index);
    }

    @Override
    public <R> List<R> getClasses(Class<R> resourceClass) {
        ArrayList<R> l = new ArrayList<R>();
        for (Object o : this.classList) {
            l.add(resourceClass.cast(o));
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public List<GraphMap> getGraphMaps() {
        return Collections.unmodifiableList(this.graphList);
    }

    @Override
    public void removeClass(Object classURI) {
        this.classList.remove(classURI);
    }

    @Override
    public void removeGraphMap(GraphMap gm) {
        this.classList.remove(gm);
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.addAll(super.serialize(tripleClass));
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#SubjectMap"))));
        for (Object cl : this.classList) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#class"), cl)));
        }
        for (GraphMap g : this.graphList) {
            if (g.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#graph"), this.lc.createResource(g.getConstant()))));
                continue;
            }
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#graphMap"), g.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(g.serialize(tripleClass));
        }
        return stmtSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classList == null ? 0 : this.classList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubjectMapImpl)) {
            return false;
        }
        SubjectMapImpl other = (SubjectMapImpl)obj;
        return !(this.classList == null ? other.classList != null : !this.classList.equals(other.classList));
    }

    @Override
    public String toString() {
        return "SubjectMapImpl [classList=" + String.valueOf(this.classList) + ", graphList=" + String.valueOf(this.graphList) + ", type=" + String.valueOf((Object)this.type) + ", termtype=" + String.valueOf(this.termtype) + ", template=" + String.valueOf(this.template) + ", constVal=" + this.constVal + ", columnName=" + this.columnName + ", inverseExp=" + String.valueOf(this.inverseExp) + ", res=" + String.valueOf(this.res) + "]";
    }
}

