/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.Join;
import eu.optique.api.mapping.LibConfiguration;
import java.util.HashSet;
import java.util.Set;

public class JoinImpl
implements Join {
    String child;
    String parent;
    Object res;
    final LibConfiguration lc;

    public JoinImpl(LibConfiguration c, String childCol, String parentCol) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.setChild(childCol);
        this.setParent(parentCol);
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void setChild(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("A Join must have a child column.");
        }
        this.child = columnName;
    }

    @Override
    public void setParent(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("A Join must have a parent column.");
        }
        this.parent = columnName;
    }

    @Override
    public String getChild() {
        return this.child;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#Join"))));
        stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#child"), this.child)));
        stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#parent"), this.parent)));
        return stmtSet;
    }

    @Override
    public void setResource(Object r) {
        if (r != null && !this.lc.getResourceClass().isInstance(r)) {
            throw new IllegalArgumentException("Parameter r is of type " + String.valueOf(r.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        if (r == null) {
            throw new NullPointerException("A Join must have a resource.");
        }
        this.res = r;
    }

    @Override
    public <R> R getResource(Class<R> resourceClass) {
        return resourceClass.cast(this.res);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinImpl)) {
            return false;
        }
        JoinImpl other = (JoinImpl)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.res == null ? other.res != null : !this.res.equals(other.res));
    }

    public String toString() {
        return "JoinImpl [child=" + this.child + ", parent=" + this.parent + ", res=" + String.valueOf(this.res) + "]";
    }
}

