/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api.admin;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.virtual.api.DataSourceQueryResult;
import com.complexible.stardog.virtual.api.VirtualGraph;
import com.complexible.stardog.virtual.api.admin.DataSourceInfo;
import com.complexible.stardog.virtual.api.admin.VirtualGraphInfo;
import com.google.common.annotations.Beta;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public interface VirtualGraphAdminConnection
extends AdminConnection {
    public static final String ALL_DBS = "*";
    public static final String ALL_NAMED_GRAPHS = "*";

    public Collection<VirtualGraphInfo> getVirtualGraphInfos();

    @Deprecated
    public VirtualGraph getGraph(String var1);

    public VirtualGraphInfo getVirtualGraphInfo(String var1);

    public VirtualGraphInfo getVirtualGraphInfoOrNull(String var1);

    public Properties getOptions(String var1);

    default public String getMappings(String vgName) {
        return this.getMappingsString(vgName, "R2RML");
    }

    public String getMappingsString(String var1, String var2);

    public boolean removeGraph(String var1);

    public void onlineGraph(String var1);

    default public void addGraph(String theName, Properties theOptions, Iterable<Statement> theMappings) {
        this.addGraph(theName, "*", theOptions, theMappings);
    }

    public void addGraph(String var1, String var2, Properties var3, Iterable<Statement> var4);

    public void addGraph(String var1, String var2, String var3, Properties var4, Iterable<Statement> var5);

    default public void addGraph(String theName, Properties theOptions, String theMappings) {
        this.addGraph(theName, "*", theOptions, theMappings);
    }

    @Deprecated
    public void addGraph(String var1, String var2, Properties var3, String var4);

    default public void addGraph(String theName, String theDataSource, String theDatabase, Properties theOptions, String theMappings) {
        this.addGraph(theName, theDataSource, null, theDatabase, theOptions, theMappings);
    }

    @Deprecated
    public void addGraph(String var1, @Nullable String var2, @Nullable Set<Statement> var3, String var4, Properties var5, String var6);

    default public void updateGraph(String theName, Properties theOptions, Iterable<Statement> theMappings) {
        this.updateGraph(theName, "*", theOptions, theMappings);
    }

    public void updateGraph(String var1, String var2, Properties var3, Iterable<Statement> var4);

    default public void updateGraph(String theName, Properties theOptions, String theMappings) {
        this.updateGraph(theName, "*", theOptions, theMappings);
    }

    @Deprecated
    public void updateGraph(String var1, String var2, Properties var3, String var4);

    default public void updateGraph(String theName, String theDataSource, String theDatabase, Properties theOptions, String theMappings) {
        this.updateGraph(theName, theDataSource, null, theDatabase, theOptions, theMappings);
    }

    @Deprecated
    public void updateGraph(String var1, @Nullable String var2, @Nullable Set<Statement> var3, String var4, Properties var5, String var6);

    @Deprecated
    default public void importGraph(String theDatabase, Properties theOptions, String theMappings, String theNamedGraph, boolean theRemoveAll) {
        this.importGraph(theDatabase, null, theOptions, theMappings, theNamedGraph, theRemoveAll);
    }

    public void importGraph(String var1, @Nullable String var2, Properties var3, String var4, String var5, boolean var6);

    public void importFile(String var1, Properties var2, String var3, IRI var4, File var5, InputFileType var6);

    public void importFile(String var1, Properties var2, String var3, IRI var4, InputStream var5, String var6, IRI var7, InputFileType var8);

    public void addDataSource(String var1, Properties var2);

    default public void updateDataSource(String theName, Properties theOptions) {
        this.updateDataSource(theName, theOptions, false);
    }

    default public void updateDataSource(String theName, Properties theOptions, boolean theForce) {
        this.updateDataSource(theName, null, theOptions, theForce, true);
    }

    @Deprecated
    public void updateDataSource(String var1, @Nullable Set<Statement> var2, Properties var3, boolean var4, boolean var5);

    public void modifyDataSource(String var1, Properties var2);

    public boolean removeDataSource(String var1, boolean var2);

    public void shareDataSource(String var1);

    public Collection<DataSourceInfo> getDataSourceInfos();

    public void onlineDataSource(String var1);

    public void testDataSource(String var1);

    default public void testNewConnection(Properties theOptions) {
        String name = UUID.randomUUID().toString();
        this.addDataSource(name, theOptions);
        try {
            this.testDataSource(name);
        }
        finally {
            this.removeDataSource(name, true);
        }
    }

    public DataSourceInfo getDataSourceInfo(String var1);

    default public DataSourceInfo getDataSourceInfoOrNull(String theName) {
        try {
            return this.getDataSourceInfo(theName);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    public Properties getDataSourceOptions(String var1);

    @Beta
    public Set<Statement> getDataSourceMetadata(String var1);

    @Beta
    public JsonArray getDataSourceTables(String var1);

    @Beta
    public Set<Statement> getTableMetadataRdf(String var1, @Nullable String var2, @Nullable String var3, String var4, String var5);

    @Beta
    public JsonObject getTableMetadataJson(String var1, @Nullable String var2, @Nullable String var3, String var4, String var5);

    public void refreshMetadata(String var1, @Nullable String var2);

    public void replaceTableMetadata(String var1, @Nullable String var2, @Nullable String var3, String var4, String var5, Set<Statement> var6, Map<String, Boolean> var7);

    public void replaceAllMetadata(String var1, Set<Statement> var2, Map<String, Boolean> var3);

    public void refreshCounts(String var1, @Nullable String var2);

    @Beta
    public void replaceDataSourceMetadata(String var1, Collection<Statement> var2);

    public DataSourceQueryResult queryDataSource(String var1, String var2, String var3, Properties var4);

    public String getDbTypeOptionsDescription();

    public Set<Statement> getMatchingSuggestions(Set<Statement> var1);

    public static enum InputFileType {
        JSON,
        DELIMITED;

    }
}

