/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api.admin;

import com.google.common.base.Preconditions;
import com.stardog.stark.IRI;

public class DataSourceInfo {
    private final IRI mEntityName;
    private final String mName;
    private final boolean mSharable;
    private final boolean mAvailable;
    private final String mType;

    public DataSourceInfo(IRI entityName, boolean sharable, boolean available, String type) {
        Preconditions.checkArgument((boolean)entityName.toString().startsWith("data-source://"));
        this.mEntityName = entityName;
        this.mName = entityName.toString().substring("data-source://".length());
        this.mSharable = sharable;
        this.mAvailable = available;
        this.mType = type;
    }

    public IRI getEntityName() {
        return this.mEntityName;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isSharable() {
        return this.mSharable;
    }

    public boolean isAvailable() {
        return this.mAvailable;
    }

    public String getType() {
        return this.mType;
    }

    public String toString() {
        return this.mName + (this.mSharable ? "(shared, " : "(private, ") + (this.mAvailable ? "available)" : "unavailable)") + " " + this.mType;
    }
}

