/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import java.io.File;

public enum VirtualGraphMappingSyntax {
    R2RML,
    SMS1,
    SMS2{

        public String toString() {
            return "SMS";
        }
    };

    public static final String MAPPING_SYNTAX_DEFAULT = "DEFAULT";

    public static VirtualGraphMappingSyntax get(String name) throws IllegalArgumentException {
        try {
            if (name.equalsIgnoreCase(MAPPING_SYNTAX_DEFAULT)) {
                return SMS2;
            }
            if (name.equalsIgnoreCase("SMS")) {
                return SMS2;
            }
            return VirtualGraphMappingSyntax.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Not a valid mapping syntax: " + name);
        }
    }

    public static VirtualGraphMappingSyntax get(String syntax, File mappingsFile) {
        if (syntax.equals(MAPPING_SYNTAX_DEFAULT) && mappingsFile != null) {
            String extension = mappingsFile.getName().toLowerCase();
            if (extension.endsWith(".sms") || extension.endsWith(".sms2") || extension.endsWith(".rq")) {
                return SMS2;
            }
            if (extension.endsWith(".ttl")) {
                return R2RML;
            }
        }
        return VirtualGraphMappingSyntax.get(syntax);
    }
}

