/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.google.common.base.Preconditions;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public interface VirtualGraph {
    public static final Pattern RESOURCE_NAME_MATCHER = Pattern.compile("^\\*$|^[A-Za-z0-9_]{1}[A-Za-z0-9_/#\\-\\@\\.\\+:\\\\]*$");

    public static IRI term(String theGraph) {
        return Values.iri((String)("virtual://" + theGraph));
    }

    public static String getLocalName(IRI entityName) {
        Preconditions.checkArgument((boolean)entityName.toString().startsWith("virtual://"));
        return entityName.toString().substring("virtual://".length());
    }

    @Deprecated
    public static String service(String theGraph) {
        return "graph <" + String.valueOf(VirtualGraph.term(theGraph)) + ">";
    }

    public static String graphClause(String theGraph) {
        return "graph <" + String.valueOf(VirtualGraph.term(theGraph)) + ">";
    }

    public static String serviceClause(String theGraph) {
        return "service <" + String.valueOf(VirtualGraph.term(theGraph)) + ">";
    }

    public String getName();

    public IRI getDataSourceName();

    public String getDatabase();

    public Set<Statement> getMappings();

    public Properties getOptions();

    public boolean isAvailable();
}

