/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import eu.optique.api.mapping.Join;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.R2RMLMappingManager;
import eu.optique.api.mapping.RefObjectMap;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.InvalidR2RMLMappingException;
import eu.optique.api.mapping.impl.sesame.SesameR2RMLMappingManagerFactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinConditionOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinConditionOptimizer.class);
    private static final R2RMLMappingManager MANAGER = new SesameR2RMLMappingManagerFactory().getR2RMLMappingManager();
    private static final MappingFactory FACTORY = MANAGER.getMappingFactory();

    public static Set<Statement> optimizeJoinConditions(Set<Statement> theMappings) throws InvalidR2RMLMappingException {
        Collection<TriplesMap> aTriplesMaps = MANAGER.importMappings(theMappings);
        boolean aOptimized = JoinConditionOptimizer.optimizeJoinConditions(aTriplesMaps);
        return aOptimized ? MANAGER.exportMappings(aTriplesMaps, Set.class) : theMappings;
    }

    public static boolean optimizeJoinConditions(Iterable<TriplesMap> theTriplesMap) {
        boolean aOptimized = false;
        for (TriplesMap aTriplesMap : theTriplesMap) {
            for (PredicateObjectMap aPredicateObjectMap : aTriplesMap.getPredicateObjectMaps()) {
                ArrayDeque aRemoveQueue = Queues.newArrayDeque();
                for (RefObjectMap aRefObjectMap : aPredicateObjectMap.getRefObjectMaps()) {
                    Function<String, String> aColumnMap;
                    TriplesMap aParentMap = aRefObjectMap.getParentMap();
                    SubjectMap aParentSubject = aParentMap.getSubjectMap();
                    ObjectMap aObjectMap = JoinConditionOptimizer.createObjectMap(aParentSubject, aColumnMap = JoinConditionOptimizer.createColumnMap(aRefObjectMap.getJoinConditions()));
                    if (aObjectMap == null) continue;
                    aPredicateObjectMap.addObjectMap(aObjectMap);
                    aRemoveQueue.add(aRefObjectMap);
                }
                aOptimized |= !aRemoveQueue.isEmpty();
                while (!aRemoveQueue.isEmpty()) {
                    RefObjectMap aRefObjectMap = (RefObjectMap)aRemoveQueue.remove();
                    aPredicateObjectMap.removeRefObjectMap(aRefObjectMap);
                }
            }
        }
        return aOptimized;
    }

    private static Function<String, String> createColumnMap(Iterable<Join> theJoinConditions) {
        HashMap aMap = Maps.newHashMap();
        for (Join aJoinCondition : theJoinConditions) {
            aMap.put(aJoinCondition.getParent(), aJoinCondition.getChild());
        }
        return aMap.isEmpty() ? Functions.identity() : Functions.forMap((Map)aMap, null);
    }

    private static ObjectMap createObjectMap(SubjectMap theSubjectMap, Function<String, String> theColumnMap) {
        ObjectMap aObjectMap;
        TermMap.TermMapType aType = theSubjectMap.getTermMapType();
        if (aType == TermMap.TermMapType.TEMPLATE_VALUED) {
            String aTemplateStr = theSubjectMap.getTemplateString();
            for (String aParentColumn : theSubjectMap.getTemplate().getColumnNames()) {
                String aChildColumn = (String)theColumnMap.apply((Object)aParentColumn);
                if (aChildColumn == null) {
                    return null;
                }
                aTemplateStr = aTemplateStr.replace("{" + aParentColumn + "}", "{" + aChildColumn + "}");
            }
            aObjectMap = FACTORY.createObjectMap(FACTORY.createTemplate(aTemplateStr));
        } else if (aType == TermMap.TermMapType.COLUMN_VALUED) {
            String aParentColumn = theSubjectMap.getColumn();
            String aChildColumn = (String)theColumnMap.apply((Object)aParentColumn);
            if (aChildColumn == null) {
                return null;
            }
            aObjectMap = FACTORY.createObjectMap(aType, aChildColumn);
        } else {
            aObjectMap = FACTORY.createObjectMap(aType, theSubjectMap.getConstant());
        }
        aObjectMap.setTermType(theSubjectMap.getTermType(IRI.class));
        return aObjectMap;
    }
}

