/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.common.base.Pair;
import java.util.Map;
import java.util.Properties;

public class JdbcOptions {
    public static final String JDBC_URL = "jdbc.url";
    public static final String JDBC_USERNAME = "jdbc.username";
    public static final String JDBC_PASSWORD = "jdbc.password";
    public static final String JDBC_DRIVER = "jdbc.driver";
    public static final String JDBC_PASSTHROUGH = "jdbc.passthrough";
    public static final String JDBC_PASSTHROUGH_SCOPE = "jdbc.passthrough.scope";
    public static final String JDBC_PASSTHROUGH_OAUTH = "OAUTH";
    public static final String PASSTHROUGH_PREFIX = "passthrough.";
    public static final String PASSTHROUGH_ACCESS_TOKEN = "ACCESS_TOKEN";
    public static final String SQL_DIALECT = "sql.dialect";
    public static final String SQL_DEFAULT_CATALOG = "sql.default.catalog";
    public static final String SQL_CATALOGS = "sql.catalogs";
    public static final String SQL_DEFAULT_SCHEMA = "sql.default.schema";
    public static final String SQL_SCHEMAS = "sql.schemas";
    public static final String SQL_WILDCARD = "*";
    public static final String SQL_SKIP_VALIDATION = "sql.skip.validation";
    public static final String JDBC_STATEMENT_FETCH_SIZE = "jdbc.statement.fetch.size";
    public static final String JDBC_ROW_COUNT_ESTIMATE_STRATEGY = "jdbc.row.count.estimate.strategy";
    public static final String JDBC_TABLE_SAMPLE_PERCENTAGE = "jdbc.table.sample.percentage";

    public static Properties getDriverProperties(Map<?, ?> dsOptions) {
        Properties driverOptions = new Properties();
        dsOptions.entrySet().stream().map(Pair.fromMapEntry()).map(Pair.liftOverFirst(String.class::cast)).filter(p -> ((String)p.first).startsWith("ext.")).map(Pair.liftOverFirst(x -> x.replaceFirst("^ext\\.", ""))).forEach(Pair.pairBiConsumer(driverOptions::put));
        String url = ((String)dsOptions.get(JDBC_URL)).toLowerCase();
        if (url.startsWith("jdbc:spark://")) {
            driverOptions.setProperty("UserAgentEntry", "Stardog/12.0.0 (Simba)");
        } else if (url.startsWith("jdbc:databricks://")) {
            driverOptions.setProperty("UserAgentEntry", "Stardog/12.0.0 (Databricks)");
        } else if (url.startsWith("jdbc:snowflake://")) {
            driverOptions.setProperty("application", "Stardog_Stardog");
        }
        return driverOptions;
    }

    public static boolean isSkipValidation(Properties options) {
        return Boolean.parseBoolean(options.getProperty(SQL_SKIP_VALIDATION));
    }

    public static String passthroughOption(String optionName) {
        return PASSTHROUGH_PREFIX + optionName;
    }

    public static enum RowCountEstimateStrategy {
        JDBC_GET_INDEX_INFO,
        COUNT_FALLBACK,
        COUNT_FIRST;

    }
}

