/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.stardog.StardogException;
import java.util.HashMap;
import java.util.Map;

public class DataSourceQueryResult {
    private Map<Integer, DataSourceColumn> mColumns = new HashMap<Integer, DataSourceColumn>();
    private Map<Integer, Map<Integer, Object>> mRows = new HashMap<Integer, Map<Integer, Object>>();

    public void addColumn(int theOrder, String theName, String theType, int theSize) {
        DataSourceColumn aColumn = new DataSourceColumn(theName, theType, theSize);
        this.mColumns.put(theOrder, aColumn);
    }

    public int getColumnCount() {
        return this.mColumns.size();
    }

    public int getRowCount() {
        return this.mRows.size();
    }

    public String getColumnName(int theOrder) {
        if (!this.mColumns.containsKey(theOrder)) {
            throw new StardogException("Datasource column not found at position " + theOrder);
        }
        return this.mColumns.get((Object)Integer.valueOf((int)theOrder)).mName;
    }

    public String getColumnType(int theOrder) {
        if (!this.mColumns.containsKey(theOrder)) {
            throw new StardogException("Datasource column not found at position " + theOrder);
        }
        return this.mColumns.get((Object)Integer.valueOf((int)theOrder)).mType;
    }

    public int getColumnSize(int theOrder) {
        if (!this.mColumns.containsKey(theOrder)) {
            throw new StardogException("Datasource column not found at position " + theOrder);
        }
        return this.mColumns.get((Object)Integer.valueOf((int)theOrder)).mSize;
    }

    public void addValue(int theRowOrder, int theColumnIndex, Object theValue) {
        if (!this.mRows.containsKey(theRowOrder)) {
            HashMap<Integer, Object> colMap = new HashMap<Integer, Object>();
            colMap.put(theColumnIndex, theValue);
            this.mRows.put(theRowOrder, colMap);
        } else if (!this.mRows.get(theRowOrder).containsKey(theColumnIndex)) {
            this.mRows.get(theRowOrder).put(theColumnIndex, theValue);
        }
    }

    public Object getValue(int theRowOrder, int theColumnIndex) {
        if (!this.mRows.containsKey(theRowOrder)) {
            throw new StardogException("Datasource row not found at position " + theRowOrder);
        }
        if (!this.mColumns.containsKey(theColumnIndex)) {
            throw new StardogException("Datasource column not found at position " + theColumnIndex);
        }
        return this.mRows.get(theRowOrder).get(theColumnIndex);
    }

    private static class DataSourceColumn {
        private String mName;
        private String mType;
        private int mSize;

        public DataSourceColumn(String theName, String theType, int theSize) {
            this.mName = theName;
            this.mType = theType;
            this.mSize = theSize;
        }
    }
}

