/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.common.base.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceOptions.class);
    public static final int DEFAULT_RESULT_LIMIT = 101000;
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final String DATA_SOURCE_QUERY_RESULT_LIMIT = "data.source.query.result.limit";
    public static final String UNIQUE_KEY_SETS = "unique.key.sets";
    public static final String BATCH_SIZE = "batch.size";
    public static final String SECRETS_MANAGER = "secrets.manager";
    public static final String SECRETS_KEY = "secrets.key";
    public static final String SECRETS_VERSION = "secrets.version";
    public static final String SECRETS_AWS_REGION = "secrets.aws.manager";
    public static final String SECRETS_AWS_SECRET_KEY = "secrets.aws.secret.key";
    public static final String SECRETS_AWS_ACCESS_KEY = "secrets.aws.access.key";
    public static final String SECRETS_GOOGLE_PROJECT_ID = "secrets.google.project.id";
    public static final String SECRETS_GOOGLE_KEY = "secrets.google.key";
    public static final String SECRETS_AZURE_URL = "secrets.azure.url";
    public static final String SECRETS_AZURE_TENANT_ID = "secrets.azure.tenant.id";
    public static final String SECRETS_AZURE_CLIENT_ID = "secrets.azure.client.id";
    public static final String SECRETS_AZURE_CLIENT_SECRET = "secrets.azure.client.secret";
    public static final String SECRETS_HASHICORP_VAULT_URL = "secrets.hashicorp.vault.url";
    public static final String SECRETS_HASHICORP_VAULT_TOKEN = "secrets.hashicorp.vault.token";

    public static Map<String, Set<Set<String>>> getUniqueKeySets(Properties options) {
        String uniqueKeySets = options.getProperty(UNIQUE_KEY_SETS);
        return UniqueKeysParser.parseUniqueKeys(uniqueKeySets);
    }

    public static Map<String, Set<Set<String>>> getUniqueKeySets(Properties options, Function<String, Pair<String, String>> splitTableColumn) {
        String uniqueKeySets = options.getProperty(UNIQUE_KEY_SETS);
        return UniqueKeysParser.parseUniqueKeys(uniqueKeySets, splitTableColumn);
    }

    public static int getBatchSize(Properties options) {
        try {
            String batchSizeProperty = options.getProperty(BATCH_SIZE);
            return batchSizeProperty != null ? Math.max(0, Integer.parseInt(batchSizeProperty)) : 100;
        }
        catch (Exception theException) {
            LOGGER.debug("Invalid batch size option value \n {}. Using default batch size instead.", (Object)options.getProperty(BATCH_SIZE));
            return 100;
        }
    }

    private static class UniqueKeysParser {
        private static final Pattern LISTS_PATTERN = Pattern.compile("\\s*\\((.*?)\\)(\\s*,)?");

        private UniqueKeysParser() {
        }

        private static Map<String, Set<Set<String>>> parseUniqueKeys(String listOfKeySets) {
            return UniqueKeysParser.parseUniqueKeys(listOfKeySets, s -> s.contains(".") ? Pair.create((Object)s.substring(0, s.lastIndexOf(46)), (Object)s.substring(s.lastIndexOf(46) + 1)) : Pair.create((Object)"", (Object)s));
        }

        private static Map<String, Set<Set<String>>> parseUniqueKeys(String listOfKeySets, Function<String, Pair<String, String>> splitTableColumn) {
            if (listOfKeySets == null) {
                return null;
            }
            List<List<String>> parsedSets = UniqueKeysParser.parseSets(listOfKeySets);
            HashMap<String, Set<Set<String>>> keySetsByTable = new HashMap<String, Set<Set<String>>>();
            parsedSets.stream().map(qualifiedKeys -> UniqueKeysParser.parseIntoTableKeySetPair(qualifiedKeys, splitTableColumn)).forEach(pair -> UniqueKeysParser.addToKeySetsByTable(keySetsByTable, (Pair<String, Set<String>>)pair));
            return keySetsByTable;
        }

        private static List<List<String>> parseSets(String s) {
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            Matcher matcher = LISTS_PATTERN.matcher(s);
            int start = 0;
            while (start < s.length()) {
                if (matcher.find(start) && matcher.start() == start) {
                    String list = matcher.group(1);
                    lists.add(Arrays.asList(list.split("\\s*,\\s*")));
                    start = matcher.end();
                    continue;
                }
                throw new IllegalArgumentException("Expecting start of new list at offset " + start + ". Actual: " + s.substring(start));
            }
            return lists;
        }

        private static Pair<String, Set<String>> parseIntoTableKeySetPair(List<String> qualifiedKeys, Function<String, Pair<String, String>> splitTableColumn) {
            Map<String, List<Pair>> groups = qualifiedKeys.stream().map(splitTableColumn).collect(Collectors.groupingBy(Pair::first));
            if (groups.size() > 1) {
                throw new IllegalArgumentException("Only one table can be referenced per key set. Found: " + String.valueOf(qualifiedKeys));
            }
            String table = groups.keySet().iterator().next();
            Set keySet = groups.get(table).stream().map(Pair::second).collect(Collectors.toSet());
            return Pair.create((Object)table, keySet);
        }

        private static void addToKeySetsByTable(Map<String, Set<Set<String>>> keySetsByTable, Pair<String, Set<String>> tableKeySetPair) {
            Set keySet;
            Set keySets = keySetsByTable.computeIfAbsent((String)tableKeySetPair.first(), k -> new LinkedHashSet());
            if (!keySets.add(keySet = (Set)tableKeySetPair.second())) {
                throw new IllegalArgumentException("Duplicate unique key set: " + String.valueOf(keySet));
            }
        }
    }
}

