/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.text.tsv;

import com.complexible.common.base.Options;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.SelectQueryResultParser;
import com.stardog.stark.vocabs.XSD;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class SPARQLTSVResultParser
implements SelectQueryResultParser {
    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.TSV;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull SelectQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        String nextLine;
        InputStreamReader r = new InputStreamReader(theStream, this.format().charset());
        BufferedReader aReader = new BufferedReader(r);
        theHandler.start();
        String[] aVars = aReader.readLine().split("\t", -1);
        ArrayList<String> bindingNames = new ArrayList<String>(aVars.length);
        for (String aName : aVars) {
            if ('?' == aName.charAt(0)) {
                bindingNames.add(aName.substring(1));
                continue;
            }
            bindingNames.add(aName);
        }
        theHandler.variables(bindingNames);
        while ((nextLine = aReader.readLine()) != null) {
            BindingSets.Builder aBuilder = BindingSets.builder();
            String[] aTokens = nextLine.split("\t", -1);
            for (int i = 0; i < aTokens.length; ++i) {
                String aValueStr = aTokens[i];
                BNode aValue = null;
                if (aValueStr.startsWith("_:")) {
                    aValue = Values.bnode((String)aValueStr.substring(2));
                } else if (aValueStr.startsWith("<") && aValueStr.endsWith(">")) {
                    try {
                        aValue = Values.iri((String)aValueStr.substring(1, aValueStr.length() - 1));
                    }
                    catch (IllegalArgumentException e) {
                        aValue = Values.literal((String)aValueStr);
                    }
                } else if (aValueStr.startsWith("\"")) {
                    aValue = this.parseLiteral(aValueStr);
                } else if (!"".equals(aValueStr)) {
                    if (aValueStr.matches("^[\\+\\-]?[\\d\\.].*")) {
                        IRI datatype = null;
                        if (XMLDatatypes.isValidInteger((String)aValueStr)) {
                            datatype = XMLDatatypes.isValidNegativeInteger((String)aValueStr) ? XSD.NEGATIVE_INTEGER : XSD.INTEGER;
                        } else if (XMLDatatypes.isValidDecimal((String)aValueStr)) {
                            datatype = XSD.DECIMAL;
                        } else if (XMLDatatypes.isValidDouble((String)aValueStr)) {
                            datatype = XSD.DOUBLE;
                        }
                        aValue = datatype != null ? Values.literal((String)aValueStr, (IRI)datatype) : Values.literal((String)aValueStr);
                    } else {
                        aValue = Values.literal((String)aValueStr);
                    }
                }
                aBuilder.add((String)bindingNames.get(i), (Value)aValue);
            }
            theHandler.handle((Object)aBuilder.build());
        }
        theHandler.end();
    }

    private Literal parseLiteral(@Nonnull String theLiteral) throws IllegalArgumentException {
        int endLabelIdx;
        if (theLiteral.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(theLiteral)) != -1) {
            int startLangIdx = theLiteral.indexOf("@", endLabelIdx);
            int startDtIdx = theLiteral.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = theLiteral.substring(1, endLabelIdx);
            label = SPARQLTSVResultParser.decodeString(label);
            if (startLangIdx != -1) {
                String language = theLiteral.substring(startLangIdx + 1);
                return Values.literal((String)label, (String)language);
            }
            if (startDtIdx != -1) {
                String datatype = theLiteral.substring(startDtIdx + 2);
                datatype = datatype.substring(1, datatype.length() - 1);
                return Values.literal((String)label, (IRI)Values.iri((String)datatype));
            }
            return Values.literal((String)label);
        }
        throw new IllegalArgumentException("Not a legal literal: " + theLiteral);
    }

    private int findEndOfLabel(@Nonnull String theLiteral) {
        return theLiteral.lastIndexOf("\"");
    }

    public static String decodeString(@Nonnull String theStr) {
        int backSlashIdx = theStr.indexOf(92);
        if (backSlashIdx == -1) {
            return theStr;
        }
        int startIdx = 0;
        int sLength = theStr.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(theStr.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + theStr);
            }
            char c = theStr.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + theStr);
                }
                xx = theStr.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + theStr);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + theStr);
                }
                xx = theStr.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + theStr);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + theStr);
            }
            backSlashIdx = theStr.indexOf(92, startIdx);
        }
        sb.append(theStr.substring(startIdx));
        return sb.toString();
    }
}

