/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.ntriples;

import java.io.IOException;

public final class NTriplesUtil {
    public static boolean isLetterOrNumber(int c) {
        return NTriplesUtil.isLetter(c) || NTriplesUtil.isNumber(c);
    }

    public static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isStartingBnodeLabelChar(int c) {
        if (NTriplesUtil.isLetterOrNumber(c)) {
            return true;
        }
        switch (c) {
            case 95: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBnodeLabelChar(int c) {
        if (NTriplesUtil.isStartingBnodeLabelChar(c)) {
            return true;
        }
        switch (c) {
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    public static String unescapeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static String escapeString(String label) {
        try {
            StringBuilder sb = new StringBuilder(2 * label.length());
            NTriplesUtil.escapeString(label, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void escapeString(String label, Appendable appendable) throws IOException {
        NTriplesUtil.escapeString(label, appendable, true);
    }

    public static void escapeString(String label, Appendable appendable, boolean escapeUnicode) throws IOException {
        int labelLength = label.length();
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                appendable.append("\\\\");
                continue;
            }
            if (c == '\"') {
                appendable.append("\\\"");
                continue;
            }
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\r') {
                appendable.append("\\r");
                continue;
            }
            if (c == '\t') {
                appendable.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                if (escapeUnicode) {
                    appendable.append("\\u");
                    appendable.append(NTriplesUtil.toHexString(cInt, 4));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                if (escapeUnicode) {
                    appendable.append("\\U");
                    appendable.append(NTriplesUtil.toHexString(cInt, 8));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            appendable.append(c);
        }
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }

    private NTriplesUtil() {
        throw new AssertionError();
    }
}

