/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.ntriples;

import com.complexible.common.base.Options;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.ntriples.NTriplesUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public final class NTWriter
implements RDFWriter {
    private final OutputStreamWriter mWriter;
    private final Options mOptions;

    NTWriter(OutputStream theWriter, Options theOptions) {
        this.mOptions = theOptions;
        this.mWriter = new OutputStreamWriter(theWriter, this.format().charset());
    }

    public void end() {
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed("Unable to flush output after writing is complete", (Throwable)e);
        }
    }

    public void start() {
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
    }

    public void comment(@Nonnull String theComment) {
        try {
            this.mWriter.write("# ");
            this.mWriter.write(theComment);
            this.mWriter.write("\n");
        }
        catch (IOException e) {
            throw new WritingFailed("Failed while writing a comment", (Throwable)e);
        }
    }

    public void handle(@Nonnull Statement theStmt) {
        try {
            Resource aSubject = theStmt.subject();
            IRI aPredicate = theStmt.predicate();
            Value aObject = theStmt.object();
            if (aSubject instanceof Statement || aPredicate instanceof Statement || aObject instanceof Statement) {
                return;
            }
            this.serialize((Value)aSubject, this.mWriter);
            this.mWriter.append(' ');
            NTWriter.serialize(aPredicate, (Writer)this.mWriter);
            this.mWriter.append(' ');
            this.serialize(aObject, this.mWriter);
            this.mWriter.append(' ');
            this.mWriter.append('.');
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new WritingFailed("Failed writing statement", (Throwable)e);
        }
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.NTRIPLES;
    }

    private void serialize(@Nonnull Value theObj, Writer theWriter) throws IOException {
        NTWriter.serialize(theObj, this.mOptions.is(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL), theWriter);
    }

    public static void serialize(@Nonnull Value theObj, boolean theSimplify, Writer theWriter) throws IOException {
        if (theObj instanceof IRI) {
            NTWriter.serialize((IRI)theObj, theWriter);
        } else if (theObj instanceof BNode) {
            NTWriter.serialize((BNode)theObj, theWriter);
        } else if (theObj instanceof Literal) {
            NTWriter.serialize((Literal)theObj, theSimplify, theWriter);
        }
    }

    public static void serialize(@Nonnull IRI theObj, Writer theWriter) throws IOException {
        theWriter.write(60);
        theWriter.write(theObj.toString());
        theWriter.write(62);
    }

    public static void serialize(@Nonnull BNode theObj, Writer theWriter) throws IOException {
        String nextId = theObj.id();
        theWriter.append("_:");
        if (nextId.isEmpty()) {
            theWriter.append("genid");
            theWriter.append(Integer.toHexString(theObj.hashCode()));
        } else {
            if (!NTriplesUtil.isLetter(nextId.charAt(0))) {
                theWriter.append("genid");
                theWriter.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (NTriplesUtil.isLetterOrNumber(nextId.charAt(i))) {
                    theWriter.append(nextId.charAt(i));
                    continue;
                }
                theWriter.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
    }

    public static void serialize(@Nonnull Literal theObj, boolean theSimplify, Writer theWriter) throws IOException {
        boolean ignoreDatatype = theObj.datatype() == Datatype.STRING && theSimplify;
        theWriter.append('\"').append(NTriplesUtil.escapeString(theObj.label())).append('\"');
        if (theObj.lang().isPresent()) {
            theWriter.append('@').append((CharSequence)theObj.lang().get());
        } else if (!ignoreDatatype) {
            theWriter.append('^').append('^');
            NTWriter.serialize(theObj.datatypeIRI(), theWriter);
        }
    }

    public static final class NTWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.NTRIPLES;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new NTWriter(theStream, theOptions);
        }
    }
}

