/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofList;
import com.complexible.stardog.reasoning.ProofType;
import com.complexible.stardog.reasoning.Proofs;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stardog.stark.Axiom;
import com.stardog.stark.Axioms;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;

public class ProofReader
implements JsonDeserializer<ProofList> {
    public ProofList deserialize(JsonElement theJsonProof, Type theType, JsonDeserializationContext theContext) throws JsonParseException {
        return new ProofList(this.toProofNodes(theJsonProof.getAsJsonObject().get("proofs")));
    }

    Iterable<Proof> toProofNodes(JsonElement theJsonNodes) {
        JsonArray aJsonNodes = theJsonNodes.getAsJsonArray();
        ArrayList aProofNodes = Lists.newArrayList();
        if (aJsonNodes != null) {
            for (JsonElement aJsonNode : aJsonNodes) {
                aProofNodes.add(this.toProofNode(aJsonNode));
            }
        }
        return aProofNodes;
    }

    Iterable<IRI> toResources(JsonElement theJsonNodes) {
        ArrayList aProofNodes = Lists.newArrayList();
        if (theJsonNodes != null) {
            JsonArray aJsonNodes = theJsonNodes.getAsJsonArray();
            for (JsonElement aJsonNode : aJsonNodes) {
                String aResource = aJsonNode.getAsString();
                aProofNodes.add(Values.iri((String)aResource));
            }
        }
        return aProofNodes;
    }

    Proof toProofNode(JsonElement theJsonNode) {
        JsonObject aJsonObject = theJsonNode.getAsJsonObject();
        try {
            Axiom aExpression = this.toExpression(aJsonObject.get("expression").getAsString());
            ProofType aStatus = ProofType.valueOf(aJsonObject.get("status").getAsString());
            Iterable<Proof> aChildren = this.toProofNodes(aJsonObject.get("children"));
            Iterable<IRI> aNamedGraphs = this.toResources(aJsonObject.get("namedGraphs"));
            Proof aAlternate = aJsonObject.has("alternate") ? this.toProofNode(aJsonObject.get("alternate")) : null;
            return Proofs.newProof(aExpression, aStatus, aChildren, aNamedGraphs, aAlternate);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    Axiom toExpression(String theTurtleStr) throws IOException {
        Set aGraph = RDFParsers.read((InputStream)new ByteArrayInputStream(theTurtleStr.getBytes()), (RDFFormat)RDFFormats.TURTLE);
        return aGraph.isEmpty() ? null : Axioms.fromStatements((Iterable)aGraph);
    }
}

