/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.complexible.stardog.reasoning.AbstractProof;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofType;
import com.complexible.stardog.reasoning.ReasoningUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import java.util.Set;

public final class MutableProof
extends AbstractProof
implements Proof {
    private Axiom mAxiom;
    private com.stardog.stark.Axiom mExpression;
    private ProofType mType;
    private Set<MutableProof> mChildren;
    private Set<IRI> mNamedGraphs;
    private MutableProof mAlternate;

    public MutableProof(com.stardog.stark.Axiom theExpression, ProofType theType) {
        this(theExpression, theType, (Iterable<Proof>)ImmutableList.of());
    }

    public MutableProof(com.stardog.stark.Axiom theExpression, ProofType theType, Iterable<Proof> theChildren) {
        this.mType = theType;
        this.mChildren = Sets.newLinkedHashSet((Iterable)Iterables.transform(theChildren, theValue -> (MutableProof)theValue));
        this.mNamedGraphs = Sets.newHashSet();
        this.setExpression(theExpression);
    }

    @Override
    public com.stardog.stark.Axiom getExpression() {
        return this.mExpression;
    }

    @Override
    public ProofType getType() {
        return this.mType;
    }

    public void setExpression(com.stardog.stark.Axiom theExpression) {
        this.mExpression = theExpression;
        try {
            this.mAxiom = this.mExpression == null ? null : ReasoningUtils.convertToAxiom(theExpression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setType(ProofType theType) {
        this.mType = theType;
    }

    public void addChild(MutableProof theChild) {
        this.mChildren.add(theChild);
    }

    public void addChildren(Iterable<MutableProof> theChildren) {
        Iterables.addAll(this.mChildren, theChildren);
    }

    @Override
    public Iterable<Proof> getChildren() {
        return this.mChildren;
    }

    public Iterable<MutableProof> getMutableChildren() {
        return this.mChildren;
    }

    @Override
    public boolean hasChildren() {
        return !this.mChildren.isEmpty();
    }

    @Override
    protected Axiom getAxiom() {
        return this.mAxiom;
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        return this.mNamedGraphs;
    }

    public void addNamedGraph(IRI theGraph) {
        Preconditions.checkNotNull((Object)theGraph);
        this.mNamedGraphs.add(theGraph);
    }

    @Override
    public MutableProof getAlternate() {
        return this.mAlternate;
    }

    @Override
    public boolean hasAlternate() {
        return this.mAlternate != null;
    }

    public void setAlternate(MutableProof theAlternate) {
        this.mAlternate = theAlternate;
    }
}

